(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    344266,       7286]
NotebookOptionsPosition[    319346,       6938]
NotebookOutlinePosition[    319740,       6954]
CellTagsIndexPosition[    319697,       6951]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"<<", "VilTeX`"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "VilCretas`"}]}], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}, {
  3.9670548919645*^9, 3.967054892299961*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ea6cdd64-a7ca-4aba-882e-f7e2070369f6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, {3.967054894514599*^9, 3.967054903516942*^9}, 
   3.967056119535552*^9, 3.96705995647062*^9, 3.967106248063345*^9, 
   3.9671062833739243`*^9, {3.967109065984334*^9, 3.967109074875122*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"0c71df9b-7908-44bd-bf7d-265c611fe4dd"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, {3.967054894514599*^9, 3.967054903516942*^9}, 
   3.967056119535552*^9, 3.96705995647062*^9, 3.967106248063345*^9, 
   3.9671062833739243`*^9, 3.967109065984334*^9, 3.9671090979273157`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"5f58e1e9-be11-4e6e-b70c-a485291da373"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, {3.967054894514599*^9, 3.967054903516942*^9}, 
   3.967056119535552*^9, 3.96705995647062*^9, 3.967106248063345*^9, 
   3.9671062833739243`*^9, 3.967109065984334*^9, 3.9671090979280443`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"d8e6986b-725a-477b-a95f-eb2532d59c94"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, {3.967054894514599*^9, 3.967054903516942*^9}, 
   3.967056119535552*^9, 3.96705995647062*^9, 3.967106248063345*^9, 
   3.9671062833739243`*^9, 3.967109065984334*^9, 3.967109097928405*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"7e9d829d-420a-41cb-805a-1baf9583712d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, {3.967054894514599*^9, 3.967054903516942*^9}, 
   3.967056119535552*^9, 3.96705995647062*^9, 3.967106248063345*^9, 
   3.9671062833739243`*^9, 3.967109065984334*^9, 3.967109097928775*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"191f4dba-f47f-4070-a882-4e7be0122095"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, {3.967054894514599*^9, 3.967054903516942*^9}, 
   3.967056119535552*^9, 3.96705995647062*^9, 3.967106248063345*^9, 
   3.9671062833739243`*^9, 3.967109065984334*^9, 3.96710909792913*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"315b0e36-3ec8-459b-b250-0ce1d5d38186"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, {3.967054894514599*^9, 3.967054903516942*^9}, 
   3.967056119535552*^9, 3.96705995647062*^9, 3.967106248063345*^9, 
   3.9671062833739243`*^9, 3.967109065984334*^9, 3.967109097929471*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"dd3a15ee-22db-405a-8645-33dc4f4a20a5"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilCretas cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
06/09/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{
  3.9669682799375896`*^9, {3.967054894514599*^9, 3.967054903516942*^9}, 
   3.967056119535552*^9, 3.96705995647062*^9, 3.967106248063345*^9, 
   3.9671062833739243`*^9, 3.967109065984334*^9, 3.9671090979959517`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"7619862d-62e2-43fc-9771-65b4594484c9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6. ExportGraphToTikZ", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, 
   3.9664306609167547`*^9, {3.966529743447299*^9, 3.966529746603219*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ExportGraphToTikZ"}]], "Input",
 CellChangeTimes->{{3.967056315433305*^9, 3.967056319402828*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"295abe39-3f99-453c-80fa-f281dc6ba1cb"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportGraphToTikZ[graph, filename, options] \
convierte un objeto Graph de Mathematica a c\[OAcute]digo TikZ de LaTeX y lo \
exporta como un archivo .tex completo. \\n\\nARGUMENTOS:\\n- graph: Objeto \
Graph v\[AAcute]lido de Mathematica\\n- filename: Cadena de texto que debe \
terminar en '.tex' \\n- options: Secuencia de reglas de opciones para \
personalizar la apariencia\\n\\nVALOR DE RETORNO:\\n- Ruta completa del \
archivo exportado en caso de \[EAcute]xito\\n- $Failed si hay errores en los \
argumentos\\n\\nOPCIONES DISPONIBLES:\\n\\nAPARIENCIA DE \
V\[CapitalEAcute]RTICES:\\n- 'VertexSize' -> n\[UAcute]mero (default: 0.1)\\n \
 Tama\[NTilde]o de los nodos en cent\[IAcute]metros. Valores t\[IAcute]picos: \
0.1-0.3 (no maneja valores menores a 0.1)\\n\\n- 'VertexColor' -> color \
(default: 'blue')  \\n  Color de relleno de los v\[EAcute]rtices. \
Opciones:\\n  - Colores b\[AAcute]sicos: 'black', 'white', 'red', 'green', \
'blue', 'yellow', 'cyan', 'magenta', 'gray'\\n  - Colores predefinidos: \
'darkblue', 'lightblue', 'darkgreen', 'lightgreen', 'darkred', 'lightgray', \
'darkgray', 'orange', 'purple', 'pink'\\n\\n- 'VertexLabels' -> True|False \
(default: True)\\n  Mostrar o ocultar las etiquetas de los \
v\[EAcute]rtices\\n\\n- 'VertexLabelColor' -> color (default: 'black')\\n  \
Color del texto de las etiquetas de v\[EAcute]rtices. Acepta los mismos \
colores que VertexColor\\n\\n- 'NodeShape' -> forma (default: 'circle')\\n  \
Forma geom\[EAcute]trica de los nodos:\\n  - 'circle': Nodos circulares\\n  - \
'square': Nodos cuadrados/rectangulares  \\n  - 'triangle': Nodos \
triangulares\\n\\nAPARIENCIA DE ARISTAS:\\n- 'EdgeThickness' -> grosor \
(default: 'thick')\\n  Grosor de las l\[IAcute]neas de aristas:\\n  - 'thin': \
L\[IAcute]neas delgadas\\n  - 'thick': L\[IAcute]neas gruesas (default)\\n  - \
'very thick': L\[IAcute]neas muy gruesas\\n  - 'ultra thick': L\[IAcute]neas \
ultra gruesas\\n\\n- 'EdgeColor' -> color (default: 'black')\\n  Color de las \
aristas. Acepta los mismos valores que VertexColor\\n\\n- 'EdgeStyle' -> \
estilo (default: 'solid')\\n  Patr\[OAcute]n de l\[IAcute]nea para las \
aristas:\\n  - 'solid': L\[IAcute]neas s\[OAcute]lidas (default)\\n  - \
'dashed': L\[IAcute]neas discontinuas/punteadas\\n  - 'dotted': \
L\[IAcute]neas punteadas\\n  - 'thick': L\[IAcute]neas s\[OAcute]lidas \
gruesas\\n\\n- 'Directed' -> True|False|Automatic (default: Automatic, si el \
grafo original no es dirigido al poner True continua no dirigido, si el grafo \
es dirigido al poner False lo resuelve no dirigido)\\n  Control de \
direccionalidad de aristas:\\n  - True: Fuerza todas las aristas como \
dirigidas (con flechas)\\n  - False: Fuerza todas las aristas como no \
dirigidas\\n  - Automatic: Detecta autom\[AAcute]ticamente basado en el tipo \
de Graph\\n\\nPESOS DE ARISTAS:\\n- 'ShowEdgeWeights' -> True|False (default: \
True)\\n  Mostrar o ocultar los pesos de las aristas\\n\\n- 'EdgeWeightColor' \
-> color (default: 'red')\\n  Color del texto de los pesos. Acepta los mismos \
valores que VertexColor\\n\\n- 'EdgeWeightSize' -> tama\[NTilde]o (default: \
'small')\\n  Tama\[NTilde]o del texto de los pesos:\\n  - 'small': Texto \
peque\[NTilde]o (default)\\n  - 'large': Texto grande\\n  - 'Large': Texto \
muy grande\\n  - 'huge': Texto enorme\\n\\nSISTEMA DE COORDENADAS Y EJES:\\n- \
'Grid' -> True|False (default: False)\\n  Mostrar rejilla de coordenadas en \
el fondo\\n\\n- 'ShowAxes' -> True|False (default: False)\\n  Mostrar ejes de \
coordenadas X e Y\\n\\n- 'XMin' -> n\[UAcute]mero|Automatic (default: \
Automatic)\\n  L\[IAcute]mite m\[IAcute]nimo del eje X. Automatic calcula \
autom\[AAcute]ticamente\\n\\n- 'XMax' -> n\[UAcute]mero|Automatic (default: \
Automatic)  \\n  L\[IAcute]mite m\[AAcute]ximo del eje X. Automatic calcula \
autom\[AAcute]ticamente\\n\\n- 'YMin' -> n\[UAcute]mero|Automatic (default: \
Automatic)\\n  L\[IAcute]mite m\[IAcute]nimo del eje Y. Automatic calcula \
autom\[AAcute]ticamente\\n\\n- 'YMax' -> n\[UAcute]mero|Automatic (default: \
Automatic)\\n  L\[IAcute]mite m\[AAcute]ximo del eje Y. Automatic calcula \
autom\[AAcute]ticamente\\n\\n- 'GraphScale' -> n\[UAcute]mero|Automatic \
(default: Automatic, facilita manejar de manera global el tama\[NTilde]o de \
los v\[EAcute]rtices)\\n  Factor de escala global del gr\[AAcute]fico:\\n  - \
Automatic: Calcula autom\[AAcute]ticamente para ajustar a ~8cm\\n  - n\
\[UAcute]mero: Factor de escala manual (0.1-2.0 \
t\[IAcute]picamente)\\n\\nEJEMPLOS DE USO:\\nExportGraphToTikZ[grafo, \
'mi_grafo.tex']\\nExportGraphToTikZ[grafo, 'grafo.tex', 'VertexColor' -> \
'red', 'EdgeThickness' -> 'very thick']\\nExportGraphToTikZ[grafo, \
'output.tex', 'ShowAxes' -> True, 'Grid' -> True, 'Directed' -> False]\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ExportGraphToTikZ", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`graph_", ",", "VilTeX`Private`filename_", 
                    ",", "VilTeX`Private`opts___"}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`vertices", ",", "VilTeX`Private`edges", 
                    ",", "VilTeX`Private`vertexCoords", ",", 
                    "VilTeX`Private`edgeWeightRules", ",", 
                    RowBox[{"VilTeX`Private`vertexSize", "=", "0.1`"}], ",", 
                    
                    RowBox[{"VilTeX`Private`edgeThickness", "=", 
                    "\"thick\""}], ",", 
                    RowBox[{"VilTeX`Private`vertexColor", "=", "\"blue\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`edgeColor", "=", "\"black\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`vertexLabels", "=", "True"}], ",", 
                    RowBox[{"VilTeX`Private`directed", "=", "Automatic"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`nodeShape", "=", "\"circle\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`grid", "=", "False"}], ",", 
                    RowBox[{"VilTeX`Private`showAxes", "=", "False"}], ",", 
                    RowBox[{"VilTeX`Private`xmin", "=", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`xmax", "=", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymin", "=", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymax", "=", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`vertexLabelColor", "=", 
                    "\"black\""}], ",", 
                    RowBox[{"VilTeX`Private`edgeStyle", "=", "\"solid\""}], 
                    ",", 
                    RowBox[{"VilTeX`Private`showEdgeWeights", "=", "True"}], 
                    ",", 
                    
                    RowBox[{"VilTeX`Private`edgeWeightColor", "=", 
                    "\"red\""}], ",", 
                    
                    RowBox[{"VilTeX`Private`edgeWeightSize", "=", 
                    "\"small\""}], ",", 
                    RowBox[{"VilTeX`Private`graphScale", "=", "Automatic"}], 
                    ",", "VilTeX`Private`formatNum", ",", 
                    "VilTeX`Private`optionsList", ",", 
                    "VilTeX`Private`graphLayout", ",", 
                    "VilTeX`Private`originalDirected"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    
                    RowBox[{"VilTeX`Private`cleanVertexName", ",", 
                    "VilTeX`Private`SymbolQ", ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"a\"", "]"}], False, Editable -> 
                    False], ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"b\"", "]"}], False, Editable -> 
                    False], ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"c\"", "]"}], False, Editable -> 
                    False], ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"d\"", "]"}], False, Editable -> 
                    False], ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"e\"", "]"}], False, Editable -> 
                    False]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"GraphQ", "[", "VilTeX`Private`graph", "]"}]}], 
                    ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{"Return", "[", "$Failed", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`optionsList", "=", 
                    RowBox[{"{", "VilTeX`Private`opts", "}"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`optionsList", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"_String", "\[Rule]", "_"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`key", "=", 
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`value", "=", 
                    
                    RowBox[{"VilTeX`Private`optionsList", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`key", ",", "\"VertexSize\"", ",", 
                    
                    RowBox[{"VilTeX`Private`vertexSize", "=", 
                    "VilTeX`Private`value"}], ",", "\"EdgeThickness\"", ",", 
                    
                    RowBox[{"VilTeX`Private`edgeThickness", "=", 
                    "VilTeX`Private`value"}], ",", "\"VertexColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`vertexColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"EdgeColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`edgeColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"VertexLabels\"", ",", 
                    
                    RowBox[{"VilTeX`Private`vertexLabels", "=", 
                    "VilTeX`Private`value"}], ",", "\"Directed\"", ",", 
                    
                    RowBox[{"VilTeX`Private`directed", "=", 
                    "VilTeX`Private`value"}], ",", "\"NodeShape\"", ",", 
                    
                    RowBox[{"VilTeX`Private`nodeShape", "=", 
                    "VilTeX`Private`value"}], ",", "\"Grid\"", ",", 
                    
                    RowBox[{"VilTeX`Private`grid", "=", 
                    "VilTeX`Private`value"}], ",", "\"ShowAxes\"", ",", 
                    
                    RowBox[{"VilTeX`Private`showAxes", "=", 
                    "VilTeX`Private`value"}], ",", "\"XMin\"", ",", 
                    
                    RowBox[{"VilTeX`Private`xmin", "=", 
                    "VilTeX`Private`value"}], ",", "\"XMax\"", ",", 
                    
                    RowBox[{"VilTeX`Private`xmax", "=", 
                    "VilTeX`Private`value"}], ",", "\"YMin\"", ",", 
                    
                    RowBox[{"VilTeX`Private`ymin", "=", 
                    "VilTeX`Private`value"}], ",", "\"YMax\"", ",", 
                    
                    RowBox[{"VilTeX`Private`ymax", "=", 
                    "VilTeX`Private`value"}], ",", "\"VertexLabelColor\"", 
                    ",", 
                    RowBox[{"VilTeX`Private`vertexLabelColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"EdgeStyle\"", ",", 
                    
                    RowBox[{"VilTeX`Private`edgeStyle", "=", 
                    "VilTeX`Private`value"}], ",", "\"ShowEdgeWeights\"", ",", 
                    
                    RowBox[{"VilTeX`Private`showEdgeWeights", "=", 
                    "VilTeX`Private`value"}], ",", "\"EdgeWeightColor\"", ",", 
                    
                    RowBox[{"VilTeX`Private`edgeWeightColor", "=", 
                    "VilTeX`Private`value"}], ",", "\"EdgeWeightSize\"", ",", 
                    
                    RowBox[{"VilTeX`Private`edgeWeightSize", "=", 
                    "VilTeX`Private`value"}], ",", "\"GraphScale\"", ",", 
                    
                    RowBox[{"VilTeX`Private`graphScale", "=", 
                    "VilTeX`Private`value"}], ",", "_", ",", "Null"}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`optionsList", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}], ",", 
                    "0.001`"}], "]"}], ",", "InputForm"}], "]"}], ",", 
                    "\"0\""}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`cleanVertexName", "[", 
                    "VilTeX`Private`v_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`cleanName", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"ToString", "[", "VilTeX`Private`v", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`cleanName", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`cleanName", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\\"", "\[Rule]", "\"\\\\textbackslash \""}],
                     ",", 
                    RowBox[{"\"{\"", "\[Rule]", "\"\\\\{\""}], ",", 
                    RowBox[{"\"}\"", "\[Rule]", "\"\\\\}\""}], ",", 
                    RowBox[{"\"$\"", "\[Rule]", "\"\\\\$\""}], ",", 
                    RowBox[{"\"&\"", "\[Rule]", "\"\\\\&\""}], ",", 
                    RowBox[{"\"%\"", "\[Rule]", "\"\\\\%\""}], ",", 
                    RowBox[{"\"#\"", "\[Rule]", "\"\\\\#\""}], ",", 
                    RowBox[{"\"^\"", "\[Rule]", "\"\\\\textasciicircum \""}], 
                    ",", 
                    RowBox[{"\"_\"", "\[Rule]", "\"\\\\_\""}], ",", 
                    RowBox[{"\"~\"", "\[Rule]", "\"\\\\textasciitilde \""}]}],
                     "}"}]}], "]"}]}], ";", "VilTeX`Private`cleanName"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`vertices", "=", 
                    
                    RowBox[{"VertexList", "[", "VilTeX`Private`graph", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`vertices", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"#1", ",", 
                    RowBox[{"Null", "|", "_Graph", "|", "_Graphics"}]}], 
                    "]"}]}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "#1", "]"}], "||", 
                    RowBox[{"VilTeX`Private`SymbolQ", "[", "#1", "]"}], "||", 
                    
                    RowBox[{"StringQ", "[", "#1", "]"}], "||", 
                    RowBox[{"AtomQ", "[", "#1", "]"}]}], ")"}]}], "&"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[Equal]", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vertices", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    TagBox[
                    RowBox[{"Removed", "[", "\"a\"", "]"}], False, Editable -> 
                    False], ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"b\"", "]"}], False, Editable -> 
                    False], ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"c\"", "]"}], False, Editable -> 
                    False], ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"d\"", "]"}], False, Editable -> 
                    False], ",", 
                    TagBox[
                    RowBox[{"Removed", "[", "\"e\"", "]"}], False, Editable -> 
                    False]}], "}"}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`originalDirected", "=", "False"}],
                     ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`directed", "===", "Automatic"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`isDirectedQ", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isDirectedQ", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    
                    RowBox[{"DirectedGraphQ", "[", "VilTeX`Private`graph", 
                    "]"}], ",", "False"}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"TrueQ", "[", "VilTeX`Private`isDirectedQ", "]"}],
                     ",", 
                    
                    RowBox[{"VilTeX`Private`originalDirected", "=", 
                    "True"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`originalDirected"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`edgeTypes", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeTypes", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "VilTeX`Private`graph", "]"}], 
                    ",", 
                    RowBox[{"{", "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`edgeTypes", "]"}], 
                    ">", "0"}], "&&", 
                    RowBox[{"AnyTrue", "[", 
                    RowBox[{"VilTeX`Private`edgeTypes", ",", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"#1", ",", 
                    RowBox[{"_", "\[DirectedEdge]", "_"}]}], "]"}], "&"}]}], 
                    "]"}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`originalDirected", "=", 
                    "True"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`directed", "=", 
                    "VilTeX`Private`originalDirected"}], ";"}]}], "]"}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`directed", "===", "True"}], ",", 
                    
                    RowBox[{"VilTeX`Private`originalDirected", "=", 
                    "True"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`edges", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"Check", "[", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "VilTeX`Private`graph", "]"}], 
                    ",", 
                    RowBox[{"{", "}"}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`edges", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`edges", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"#1", ",", 
                    RowBox[{
                    RowBox[{"_", "\[UndirectedEdge]", "_"}], "|", 
                    RowBox[{"_", "\[DirectedEdge]", "_"}]}]}], "]"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "]"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "]"}]}], "&"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`edges", "]"}], 
                    "\[Equal]", "0"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`edgeData", ",", 
                    "VilTeX`Private`indexBasedEdges"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeData", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`graph", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"_Integer", ",", "_Integer"}], "}"}], ".."}], 
                    "}"}], ",", "\[Infinity]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`edgeData", "]"}], 
                    ">", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[GreaterEqual]", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Flatten", "[", "VilTeX`Private`edgeData", "]"}], 
                    "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`indexBasedEdges", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"VilTeX`Private`edgeData", ",", "1"}], "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`edges", "=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`originalDirected", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "\[RightDoubleBracket]"}], 
                    "\[DirectedEdge]", 
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "\[RightDoubleBracket]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "\[RightDoubleBracket]"}], 
                    "\[UndirectedEdge]", 
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "\[RightDoubleBracket]"}]}]}], 
                    "]"}], "&"}], ")"}], "/@", 
                    "VilTeX`Private`indexBasedEdges"}]}]}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`edges", "]"}], 
                    "\[Equal]", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{"VilTeX`Private`edges", "=", 
                    RowBox[{"{", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`originalDirected", ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "\[DirectedEdge]", 
                    
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "\[UndirectedEdge]", 
                    
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}]}]}], "]"}], "}"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`edgeWeightRules", "=", 
                    RowBox[{"Association", "[", "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`edgeWeights", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{"VilTeX`Private`graph", ",", "EdgeWeight"}], 
                    "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeWeights", "=!=", "$Failed"}], 
                    "&&", 
                    RowBox[{"ListQ", "[", "VilTeX`Private`edgeWeights", "]"}],
                     "&&", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`edgeWeights", 
                    "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", "VilTeX`Private`edges", "]"}]}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeWeightRules", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Thread", "[", 
                    
                    RowBox[{"VilTeX`Private`edges", "\[Rule]", 
                    "VilTeX`Private`edgeWeights"}], "]"}], "]"}]}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`edgeWeightRules", 
                    "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`graphOptions", ",", 
                    "VilTeX`Private`edgeLabelsOption", ",", 
                    "VilTeX`Private`weightRules"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphOptions", "=", 
                    RowBox[{"Options", "[", "VilTeX`Private`graph", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`edgeLabelsOption", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`graphOptions", ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`rules_", "\[RuleDelayed]", 
                    "VilTeX`Private`rules"}]}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`edgeLabelsOption", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`edgeLabelsData", "=", 
                    
                    RowBox[{"VilTeX`Private`edgeLabelsOption", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`edgeLabelsData", 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`weightRules", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`edgeLabelsData", ",", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`weightRules", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeWeightRules", "=", 
                    
                    RowBox[{"Association", "[", "VilTeX`Private`weightRules", 
                    "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`edgeWeightRules", 
                    "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`edgeWeightData", "}"}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeWeightData", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`graph", ",", 
                    RowBox[{"EdgeWeight", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`weights_", "\[RuleDelayed]", 
                    "VilTeX`Private`weights"}]}], ",", "\[Infinity]"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`edgeWeightData", 
                    "]"}], ">", "0"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`edgeWeightData", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`edgeWeightData", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", "VilTeX`Private`edges", "]"}]}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeWeightRules", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Thread", "[", 
                    RowBox[{"VilTeX`Private`edges", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`edgeWeightData", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "]"}], "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`existingCoords", "}"}], ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`existingCoords", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"PropertyValue", "[", 
                    
                    RowBox[{"VilTeX`Private`graph", ",", 
                    "VertexCoordinates"}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`existingCoords", "===", 
                    "$Failed"}], "||", 
                    RowBox[{"!", 
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`existingCoords", 
                    "]"}]}], "||", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`existingCoords", 
                    "]"}], "\[NotEqual]", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", 
                    "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`graphOptions", ",", 
                    "VilTeX`Private`coordsOption"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphOptions", "=", 
                    RowBox[{"Options", "[", "VilTeX`Private`graph", "]"}]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`coordsOption", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`graphOptions", ",", 
                    RowBox[{"VertexCoordinates", "\[Rule]", 
                    
                    RowBox[{"VilTeX`Private`coords_", "\[RuleDelayed]", 
                    "VilTeX`Private`coords"}]}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`coordsOption", 
                    "]"}], ">", "0"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`coordsOption", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`coordsOption", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "\[Equal]", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", 
                    "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`existingCoords", "=", 
                    
                    RowBox[{"VilTeX`Private`coordsOption", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`existingCoords", "=", "$Failed"}],
                     ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`existingCoords", 
                    "]"}], "&&", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`existingCoords", 
                    "]"}], "\[Equal]", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", 
                    "]"}]}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`graphLayout", "=", 
                    "VilTeX`Private`existingCoords"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphLayout", "=", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"GraphEmbedding", "[", 
                    RowBox[{"Graph", "[", 
                    
                    RowBox[{"VilTeX`Private`vertices", ",", 
                    "VilTeX`Private`edges"}], "]"}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphLayout", "===", "$Failed"}], 
                    "||", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`graphLayout", 
                    "]"}], "\[NotEqual]", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", 
                    "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`n", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}]}],
                     ",", "VilTeX`Private`angle"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphLayout", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`angle", "=", 
                    FractionBox[
                    RowBox[{"2", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{"VilTeX`Private`i", "-", "1"}], ")"}]}], 
                    "VilTeX`Private`n"]}], ";", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"Cos", "[", "VilTeX`Private`angle", "]"}]}], ",", 
                    
                    RowBox[{"2", " ", 
                    RowBox[{"Sin", "[", "VilTeX`Private`angle", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", "VilTeX`Private`n"}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`vertexCoords", "=", 
                    RowBox[{"Association", "[", 
                    RowBox[{"Thread", "[", 
                    
                    RowBox[{"VilTeX`Private`vertices", "\[Rule]", 
                    "VilTeX`Private`graphLayout"}], "]"}], "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`allCoords", "=", 
                    
                    RowBox[{"Values", "[", "VilTeX`Private`vertexCoords", 
                    "]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`allCoords", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xmin", "=", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allCoords", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], "-", "0.5`"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xmax", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allCoords", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], "+", "0.5`"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`ymin", "=", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allCoords", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], "-", "0.5`"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`ymax", "=", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allCoords", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], "+", "0.5`"}]}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xmin", "=", 
                    RowBox[{"-", "3"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xmax", "=", "3"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`ymin", "=", 
                    RowBox[{"-", "3"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`ymax", "=", "3"}]}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    
                    RowBox[{"VilTeX`Private`xmax", "-", 
                    "VilTeX`Private`xmin"}]}], ",", 
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    
                    RowBox[{"VilTeX`Private`ymax", "-", 
                    "VilTeX`Private`ymin"}]}], ",", 
                    RowBox[{"VilTeX`Private`targetSize", "=", "8"}], ",", 
                    "VilTeX`Private`scaleX", ",", "VilTeX`Private`scaleY", 
                    ",", "VilTeX`Private`finalScale"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`graphScale", "===", "Automatic"}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`scaleX", "=", 
                    FractionBox["VilTeX`Private`targetSize", 
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`xRange", ",", "0.1`"}], "]"}]]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`scaleY", "=", 
                    FractionBox["VilTeX`Private`targetSize", 
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`yRange", ",", "0.1`"}], "]"}]]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`finalScale", "=", 
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`scaleX", ",", 
                    "VilTeX`Private`scaleY", ",", "1.5`"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`finalScale", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`finalScale", ",", "0.3`"}], 
                    "]"}]}], ";"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`finalScale", "=", 
                    "VilTeX`Private`graphScale"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"\"\\\\begin{tikzpicture}[scale=\"", "<>", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"N", "[", "VilTeX`Private`finalScale", "]"}], 
                    "]"}], "<>", "\"]\\n\""}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`showAxes", "||", 
                    "VilTeX`Private`grid"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\begin{axis}[\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  xlabel={$x$}, ylabel={$y$},\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"  xmin=\"", 
                    "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`xmin", "]"}], "<>", "\", xmax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`xmax", "]"}], "<>", "\",\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"  ymin=\"", 
                    "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`ymin", "]"}], "<>", "\", ymax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`ymax", "]"}], "<>", "\",\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  width=8cm, height=6cm,\\n\""}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`grid", ",", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  grid=major,\\n\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  axis lines=\"", "<>", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`showAxes", ",", "\"center\"", ",",
                     "\"none\""}], "]"}], "<>", "\",\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  tick label style={/pgf/number \
format/fixed},\\n\""}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"  scaled ticks=false\\n]\\n\""}]}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`edge", ",", 
                    "VilTeX`Private`fromVertex", ",", 
                    "VilTeX`Private`toVertex", ",", 
                    "VilTeX`Private`fromCoord", ",", "VilTeX`Private`toCoord",
                     ",", "VilTeX`Private`arrowStyle", ",", 
                    "VilTeX`Private`lineStyle"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`edge", "=", 
                    
                    RowBox[{"VilTeX`Private`edges", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`fromVertex", "=", 
                    
                    RowBox[{"VilTeX`Private`edge", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`toVertex", "=", 
                    
                    RowBox[{"VilTeX`Private`edge", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`vertexCoords", ",", 
                    "VilTeX`Private`fromVertex"}], "]"}], "&&", 
                    RowBox[{"KeyExistsQ", "[", 
                    
                    RowBox[{"VilTeX`Private`vertexCoords", ",", 
                    "VilTeX`Private`toVertex"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`fromCoord", "=", 
                    
                    RowBox[{"VilTeX`Private`vertexCoords", "[", 
                    "VilTeX`Private`fromVertex", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`toCoord", "=", 
                    
                    RowBox[{"VilTeX`Private`vertexCoords", "[", 
                    "VilTeX`Private`toVertex", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`arrowStyle", "=", "\"\""}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`originalDirected", "||", 
                    RowBox[{"VilTeX`Private`directed", "===", "True"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`edge", ",", 
                    RowBox[{"_", "\[DirectedEdge]", "_"}]}], "]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`arrowStyle", "=", 
                    "\"-latex\""}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`lineStyle", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`edgeStyle", ",", "\"dashed\"", 
                    ",", "\"dashed\"", ",", "\"dotted\"", ",", "\"dotted\"", 
                    ",", "\"thick\"", ",", "\"very thick\"", ",", "_", ",", 
                    "\"\""}], "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`useAxisCoords", "=", 
                    
                    RowBox[{"VilTeX`Private`showAxes", "||", 
                    "VilTeX`Private`grid"}]}], ",", 
                    "VilTeX`Private`drawOptions"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`drawOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`edgeColor", "<>", "\", \"", "<>", 
                    "VilTeX`Private`edgeThickness"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`lineStyle", "\[NotEqual]", 
                    "\"\""}], ",", 
                    RowBox[{"VilTeX`Private`drawOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`drawOptions", "<>", "\", \"", 
                    "<>", "VilTeX`Private`lineStyle"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`arrowStyle", "\[NotEqual]", 
                    "\"\""}], ",", 
                    RowBox[{"VilTeX`Private`drawOptions", "=", 
                    
                    RowBox[{"VilTeX`Private`drawOptions", "<>", "\", \"", 
                    "<>", "VilTeX`Private`arrowStyle"}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\draw[\"", 
                    "<>", "VilTeX`Private`drawOptions", "<>", "\"]\""}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`useAxisCoords", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\" (axis cs:\"",
                     "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`fromCoord", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`fromCoord", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\") -- (axis cs:\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`toCoord", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`toCoord", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\");\\n\""}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\" (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`fromCoord", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`fromCoord", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}], "<>", "\") -- (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`toCoord", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`toCoord", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\");\\n\""}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`showEdgeWeights", ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeWeight", "=", "Undefined"}], 
                    ",", "VilTeX`Private`searchKeys"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`searchKeys", "=", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`edge", ",", 
                    
                    RowBox[{"VilTeX`Private`fromVertex", "\[DirectedEdge]", 
                    "VilTeX`Private`toVertex"}], ",", 
                    
                    RowBox[{"VilTeX`Private`fromVertex", "\[UndirectedEdge]", 
                    "VilTeX`Private`toVertex"}]}], "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"KeyExistsQ", "[", 
                    RowBox[{"VilTeX`Private`edgeWeightRules", ",", 
                    
                    RowBox[{"VilTeX`Private`searchKeys", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeWeight", "=", 
                    RowBox[{"VilTeX`Private`edgeWeightRules", "[", 
                    
                    RowBox[{"VilTeX`Private`searchKeys", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`j", 
                    "\[RightDoubleBracket]"}], "]"}]}], ";", 
                    RowBox[{"Break", "[", "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`j", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`searchKeys", 
                    "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`edgeWeight", "=!=", "Undefined"}],
                     "&&", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`edgeWeight", 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`midPointX", ",", 
                    "VilTeX`Private`midPointY", ",", 
                    "VilTeX`Private`weightLabel", ",", 
                    RowBox[{"VilTeX`Private`useAxisCoords", "=", 
                    
                    RowBox[{"VilTeX`Private`showAxes", "||", 
                    "VilTeX`Private`grid"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`midPointX", "=", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`fromCoord", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "+", 
                    RowBox[{"VilTeX`Private`toCoord", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ")"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`midPointY", "=", 
                    RowBox[{
                    FractionBox["1", "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`fromCoord", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "+", 
                    RowBox[{"VilTeX`Private`toCoord", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}]}], ")"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`weightLabel", "=", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`edgeWeight", 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`useAxisCoords", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\node[fill=white, inner sep=1pt, text=\"", "<>", 
                    "VilTeX`Private`edgeWeightColor", "<>", 
                    "\"] at (axis cs:\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`midPointX", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`midPointY", "]"}], "<>", 
                    "\") {\\\\small $\"", "<>", "VilTeX`Private`weightLabel", 
                    "<>", "\"$};\\n\""}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\node[fill=white, inner sep=1pt, text=\"", "<>", 
                    "VilTeX`Private`edgeWeightColor", "<>", "\"] at (\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`midPointX", "]"}], "<>", "\",\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    "VilTeX`Private`midPointY", "]"}], "<>", 
                    "\") {\\\\small $\"", "<>", "VilTeX`Private`weightLabel", 
                    "<>", "\"$};\\n\""}]}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`edges", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`vertex", ",", 
                    "VilTeX`Private`coord", ",", 
                    "VilTeX`Private`tikzNodeShape", ",", 
                    "VilTeX`Private`vertexLabel"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`vertex", "=", 
                    
                    RowBox[{"VilTeX`Private`vertices", "\[LeftDoubleBracket]",
                     "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`coord", "=", 
                    
                    RowBox[{"VilTeX`Private`vertexCoords", "[", 
                    "VilTeX`Private`vertex", "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`tikzNodeShape", "=", 
                    RowBox[{"Switch", "[", 
                    
                    RowBox[{"VilTeX`Private`nodeShape", ",", "\"square\"", 
                    ",", "\"rectangle\"", ",", "\"triangle\"", ",", 
                    "\"regular polygon, regular polygon sides=3\"", ",", "_", 
                    ",", "\"circle\""}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`vertexLabel", "=", 
                    
                    RowBox[{"VilTeX`Private`cleanVertexName", "[", 
                    "VilTeX`Private`vertex", "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`useAxisCoords", "=", 
                    
                    RowBox[{"VilTeX`Private`showAxes", "||", 
                    "VilTeX`Private`grid"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`useAxisCoords", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\node[\"", 
                    "<>", "VilTeX`Private`tikzNodeShape", "<>", "\", fill=\"",
                     "<>", "VilTeX`Private`vertexColor", "<>", 
                    "\", draw=black, minimum size=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`vertexSize", 
                    "]"}], "<>", "\"cm] (v\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\") at (axis cs:\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`coord", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`coord", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") {};\\n\""}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", "\"\\\\node[\"", 
                    "<>", "VilTeX`Private`tikzNodeShape", "<>", "\", fill=\"",
                     "<>", "VilTeX`Private`vertexColor", "<>", 
                    "\", draw=black, minimum size=\"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`vertexSize", 
                    "]"}], "<>", "\"cm] (v\"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`i", "]"}], "<>", 
                    "\") at (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`coord", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`coord", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}], "<>", 
                    "\") {};\\n\""}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`vertexLabels", ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{"VilTeX`Private`useAxisCoords", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\node[text=\"", "<>", 
                    "VilTeX`Private`vertexLabelColor", "<>", 
                    "\"] at (axis cs:\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`coord", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`coord", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}], "<>", "\") {$\"", 
                    "<>", "VilTeX`Private`vertexLabel", "<>", 
                    "\"$};\\n\""}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\node[text=\"", "<>", 
                    "VilTeX`Private`vertexLabelColor", "<>", "\"] at (\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`coord", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "<>", "\",\"", 
                    "<>", 
                    RowBox[{"VilTeX`Private`formatNum", "[", 
                    
                    RowBox[{"VilTeX`Private`coord", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}], "<>", "\") {$\"", 
                    "<>", "VilTeX`Private`vertexLabel", "<>", 
                    "\"$};\\n\""}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`vertices", "]"}]}],
                     "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`showAxes", "||", 
                    "VilTeX`Private`grid"}], ",", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\end{axis}\\n\""}]}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"VilTeX`Private`tikzCode", "<>", 
                    "\"\\\\end{tikzpicture}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\"", "<>", 
                    "\"\\\\usepackage{xcolor}\\n\"", "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`showAxes", "||", 
                    "VilTeX`Private`grid"}], ",", 
                    "\"\\\\usepackage{pgfplots}\\n\\\\pgfplotsset{compat=1.18}\
\\n\"", ",", "\"\""}], "]"}], "<>", 
                    "\"\\\\usetikzlibrary{shapes.geometric, arrows}\\n\"", 
                    "<>", "\"\\\\usepackage{amsmath}\\n\"", "<>", 
                    "\"\\\\usepackage{amssymb}\\n\"", "<>", 
                    "\"\\n% Definir colores personalizados\\n\"", "<>", 
                    "\"\\\\definecolor{darkblue}{RGB}{0,0,139}\\n\"", "<>", 
                    "\"\\\\definecolor{lightblue}{RGB}{173,216,230}\\n\"", 
                    "<>", "\"\\\\definecolor{darkgreen}{RGB}{0,100,0}\\n\"", 
                    "<>", "\"\\\\definecolor{lightgreen}{RGB}{144,238,144}\\n\
\"", "<>", "\"\\\\definecolor{darkred}{RGB}{139,0,0}\\n\"", "<>", 
                    "\"\\\\definecolor{lightgray}{RGB}{211,211,211}\\n\"", 
                    "<>", "\"\\\\definecolor{darkgray}{RGB}{169,169,169}\\n\"\
", "<>", "\"\\\\definecolor{orange}{RGB}{255,165,0}\\n\"", "<>", 
                    "\"\\\\definecolor{purple}{RGB}{128,0,128}\\n\"", "<>", 
                    "\"\\\\definecolor{pink}{RGB}{255,192,203}\\n\"", "<>", 
                    "\"\\n\\\\begin{document}\\n\"", "<>", 
                    "VilTeX`Private`tikzCode", "<>", 
                    "\"\\n\\\\end{document}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`filename", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {" "}}, 
                  GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`ExportGraphToTikZ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportGraphToTikZ[graph, filename, options] \
convierte un objeto Graph de Mathematica a c\[OAcute]digo TikZ de LaTeX y lo \
exporta como un archivo .tex completo. \\n\\nARGUMENTOS:\\n- graph: Objeto \
Graph v\[AAcute]lido de Mathematica\\n- filename: Cadena de texto que debe \
terminar en '.tex' \\n- options: Secuencia de reglas de opciones para \
personalizar la apariencia\\n\\nVALOR DE RETORNO:\\n- Ruta completa del \
archivo exportado en caso de \[EAcute]xito\\n- $Failed si hay errores en los \
argumentos\\n\\nOPCIONES DISPONIBLES:\\n\\nAPARIENCIA DE \
V\[CapitalEAcute]RTICES:\\n- 'VertexSize' -> n\[UAcute]mero (default: 0.1)\\n \
 Tama\[NTilde]o de los nodos en cent\[IAcute]metros. Valores t\[IAcute]picos: \
0.1-0.3 (no maneja valores menores a 0.1)\\n\\n- 'VertexColor' -> color \
(default: 'blue')  \\n  Color de relleno de los v\[EAcute]rtices. \
Opciones:\\n  - Colores b\[AAcute]sicos: 'black', 'white', 'red', 'green', \
'blue', 'yellow', 'cyan', 'magenta', 'gray'\\n  - Colores predefinidos: \
'darkblue', 'lightblue', 'darkgreen', 'lightgreen', 'darkred', 'lightgray', \
'darkgray', 'orange', 'purple', 'pink'\\n\\n- 'VertexLabels' -> True|False \
(default: True)\\n  Mostrar o ocultar las etiquetas de los \
v\[EAcute]rtices\\n\\n- 'VertexLabelColor' -> color (default: 'black')\\n  \
Color del texto de las etiquetas de v\[EAcute]rtices. Acepta los mismos \
colores que VertexColor\\n\\n- 'NodeShape' -> forma (default: 'circle')\\n  \
Forma geom\[EAcute]trica de los nodos:\\n  - 'circle': Nodos circulares\\n  - \
'square': Nodos cuadrados/rectangulares  \\n  - 'triangle': Nodos \
triangulares\\n\\nAPARIENCIA DE ARISTAS:\\n- 'EdgeThickness' -> grosor \
(default: 'thick')\\n  Grosor de las l\[IAcute]neas de aristas:\\n  - 'thin': \
L\[IAcute]neas delgadas\\n  - 'thick': L\[IAcute]neas gruesas (default)\\n  - \
'very thick': L\[IAcute]neas muy gruesas\\n  - 'ultra thick': L\[IAcute]neas \
ultra gruesas\\n\\n- 'EdgeColor' -> color (default: 'black')\\n  Color de las \
aristas. Acepta los mismos valores que VertexColor\\n\\n- 'EdgeStyle' -> \
estilo (default: 'solid')\\n  Patr\[OAcute]n de l\[IAcute]nea para las \
aristas:\\n  - 'solid': L\[IAcute]neas s\[OAcute]lidas (default)\\n  - \
'dashed': L\[IAcute]neas discontinuas/punteadas\\n  - 'dotted': \
L\[IAcute]neas punteadas\\n  - 'thick': L\[IAcute]neas s\[OAcute]lidas \
gruesas\\n\\n- 'Directed' -> True|False|Automatic (default: Automatic, si el \
grafo original no es dirigido al poner True continua no dirigido, si el grafo \
es dirigido al poner False lo resuelve no dirigido)\\n  Control de \
direccionalidad de aristas:\\n  - True: Fuerza todas las aristas como \
dirigidas (con flechas)\\n  - False: Fuerza todas las aristas como no \
dirigidas\\n  - Automatic: Detecta autom\[AAcute]ticamente basado en el tipo \
de Graph\\n\\nPESOS DE ARISTAS:\\n- 'ShowEdgeWeights' -> True|False (default: \
True)\\n  Mostrar o ocultar los pesos de las aristas\\n\\n- 'EdgeWeightColor' \
-> color (default: 'red')\\n  Color del texto de los pesos. Acepta los mismos \
valores que VertexColor\\n\\n- 'EdgeWeightSize' -> tama\[NTilde]o (default: \
'small')\\n  Tama\[NTilde]o del texto de los pesos:\\n  - 'small': Texto \
peque\[NTilde]o (default)\\n  - 'large': Texto grande\\n  - 'Large': Texto \
muy grande\\n  - 'huge': Texto enorme\\n\\nSISTEMA DE COORDENADAS Y EJES:\\n- \
'Grid' -> True|False (default: False)\\n  Mostrar rejilla de coordenadas en \
el fondo\\n\\n- 'ShowAxes' -> True|False (default: False)\\n  Mostrar ejes de \
coordenadas X e Y\\n\\n- 'XMin' -> n\[UAcute]mero|Automatic (default: \
Automatic)\\n  L\[IAcute]mite m\[IAcute]nimo del eje X. Automatic calcula \
autom\[AAcute]ticamente\\n\\n- 'XMax' -> n\[UAcute]mero|Automatic (default: \
Automatic)  \\n  L\[IAcute]mite m\[AAcute]ximo del eje X. Automatic calcula \
autom\[AAcute]ticamente\\n\\n- 'YMin' -> n\[UAcute]mero|Automatic (default: \
Automatic)\\n  L\[IAcute]mite m\[IAcute]nimo del eje Y. Automatic calcula \
autom\[AAcute]ticamente\\n\\n- 'YMax' -> n\[UAcute]mero|Automatic (default: \
Automatic)\\n  L\[IAcute]mite m\[AAcute]ximo del eje Y. Automatic calcula \
autom\[AAcute]ticamente\\n\\n- 'GraphScale' -> n\[UAcute]mero|Automatic \
(default: Automatic, facilita manejar de manera global el tama\[NTilde]o de \
los v\[EAcute]rtices)\\n  Factor de escala global del gr\[AAcute]fico:\\n  - \
Automatic: Calcula autom\[AAcute]ticamente para ajustar a ~8cm\\n  - n\
\[UAcute]mero: Factor de escala manual (0.1-2.0 \
t\[IAcute]picamente)\\n\\nEJEMPLOS DE USO:\\nExportGraphToTikZ[grafo, \
'mi_grafo.tex']\\nExportGraphToTikZ[grafo, 'grafo.tex', 'VertexColor' -> \
'red', 'EdgeThickness' -> 'very thick']\\nExportGraphToTikZ[grafo, \
'output.tex', 'ShowAxes' -> True, 'Grid' -> True, 'Directed' -> False]\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ExportGraphToTikZ[graph, filename, options] convierte un objeto Graph de \
Mathematica a c\[OAcute]digo TikZ de LaTeX y lo exporta como un archivo .tex \
completo. \n\nARGUMENTOS:\n- graph: Objeto Graph v\[AAcute]lido de \
Mathematica\n- filename: Cadena de texto que debe terminar en '.tex' \n- \
options: Secuencia de reglas de opciones para personalizar la apariencia\n\n\
VALOR DE RETORNO:\n- Ruta completa del archivo exportado en caso de \
\[EAcute]xito\n- $Failed si hay errores en los argumentos\n\nOPCIONES \
DISPONIBLES:\n\nAPARIENCIA DE V\[CapitalEAcute]RTICES:\n- 'VertexSize' -> n\
\[UAcute]mero (default: 0.1)\n  Tama\[NTilde]o de los nodos en \
cent\[IAcute]metros. Valores t\[IAcute]picos: 0.1-0.3 (no maneja valores \
menores a 0.1)\n\n- 'VertexColor' -> color (default: 'blue')  \n  Color de \
relleno de los v\[EAcute]rtices. Opciones:\n  - Colores b\[AAcute]sicos: \
'black', 'white', 'red', 'green', 'blue', 'yellow', 'cyan', 'magenta', 'gray'\
\n  - Colores predefinidos: 'darkblue', 'lightblue', 'darkgreen', \
'lightgreen', 'darkred', 'lightgray', 'darkgray', 'orange', 'purple', 'pink'\n\
\n- 'VertexLabels' -> True|False (default: True)\n  Mostrar o ocultar las \
etiquetas de los v\[EAcute]rtices\n\n- 'VertexLabelColor' -> color (default: \
'black')\n  Color del texto de las etiquetas de v\[EAcute]rtices. Acepta los \
mismos colores que VertexColor\n\n- 'NodeShape' -> forma (default: 'circle')\n\
  Forma geom\[EAcute]trica de los nodos:\n  - 'circle': Nodos circulares\n  - \
'square': Nodos cuadrados/rectangulares  \n  - 'triangle': Nodos triangulares\
\n\nAPARIENCIA DE ARISTAS:\n- 'EdgeThickness' -> grosor (default: 'thick')\n  \
Grosor de las l\[IAcute]neas de aristas:\n  - 'thin': L\[IAcute]neas delgadas\
\n  - 'thick': L\[IAcute]neas gruesas (default)\n  - 'very thick': \
L\[IAcute]neas muy gruesas\n  - 'ultra thick': L\[IAcute]neas ultra gruesas\n\
\n- 'EdgeColor' -> color (default: 'black')\n  Color de las aristas. Acepta \
los mismos valores que VertexColor\n\n- 'EdgeStyle' -> estilo (default: \
'solid')\n  Patr\[OAcute]n de l\[IAcute]nea para las aristas:\n  - 'solid': L\
\[IAcute]neas s\[OAcute]lidas (default)\n  - 'dashed': L\[IAcute]neas \
discontinuas/punteadas\n  - 'dotted': L\[IAcute]neas punteadas\n  - 'thick': \
L\[IAcute]neas s\[OAcute]lidas gruesas\n\n- 'Directed' -> \
True|False|Automatic (default: Automatic, si el grafo original no es dirigido \
al poner True continua no dirigido, si el grafo es dirigido al poner False lo \
resuelve no dirigido)\n  Control de direccionalidad de aristas:\n  - True: \
Fuerza todas las aristas como dirigidas (con flechas)\n  - False: Fuerza \
todas las aristas como no dirigidas\n  - Automatic: Detecta \
autom\[AAcute]ticamente basado en el tipo de Graph\n\nPESOS DE ARISTAS:\n- \
'ShowEdgeWeights' -> True|False (default: True)\n  Mostrar o ocultar los \
pesos de las aristas\n\n- 'EdgeWeightColor' -> color (default: 'red')\n  \
Color del texto de los pesos. Acepta los mismos valores que VertexColor\n\n- \
'EdgeWeightSize' -> tama\[NTilde]o (default: 'small')\n  Tama\[NTilde]o del \
texto de los pesos:\n  - 'small': Texto peque\[NTilde]o (default)\n  - \
'large': Texto grande\n  - 'Large': Texto muy grande\n  - 'huge': Texto \
enorme\n\nSISTEMA DE COORDENADAS Y EJES:\n- 'Grid' -> True|False (default: \
False)\n  Mostrar rejilla de coordenadas en el fondo\n\n- 'ShowAxes' -> \
True|False (default: False)\n  Mostrar ejes de coordenadas X e Y\n\n- 'XMin' \
-> n\[UAcute]mero|Automatic (default: Automatic)\n  L\[IAcute]mite \
m\[IAcute]nimo del eje X. Automatic calcula autom\[AAcute]ticamente\n\n- \
'XMax' -> n\[UAcute]mero|Automatic (default: Automatic)  \n  L\[IAcute]mite m\
\[AAcute]ximo del eje X. Automatic calcula autom\[AAcute]ticamente\n\n- \
'YMin' -> n\[UAcute]mero|Automatic (default: Automatic)\n  L\[IAcute]mite m\
\[IAcute]nimo del eje Y. Automatic calcula autom\[AAcute]ticamente\n\n- \
'YMax' -> n\[UAcute]mero|Automatic (default: Automatic)\n  L\[IAcute]mite m\
\[AAcute]ximo del eje Y. Automatic calcula autom\[AAcute]ticamente\n\n- \
'GraphScale' -> n\[UAcute]mero|Automatic (default: Automatic, facilita \
manejar de manera global el tama\[NTilde]o de los v\[EAcute]rtices)\n  Factor \
de escala global del gr\[AAcute]fico:\n  - Automatic: Calcula \
autom\[AAcute]ticamente para ajustar a ~8cm\n  - n\[UAcute]mero: Factor de \
escala manual (0.1-2.0 t\[IAcute]picamente)\n\nEJEMPLOS DE USO:\n\
ExportGraphToTikZ[grafo, 'mi_grafo.tex']\nExportGraphToTikZ[grafo, \
'grafo.tex', 'VertexColor' -> 'red', 'EdgeThickness' -> 'very thick']\n\
ExportGraphToTikZ[grafo, 'output.tex', 'ShowAxes' -> True, 'Grid' -> True, \
'Directed' -> False]", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`ExportGraphToTikZ, {VilTeX`ExportGraphToTikZ[
         Pattern[VilTeX`Private`graph, 
          Blank[]], 
         Pattern[VilTeX`Private`filename, 
          Blank[]], 
         Pattern[VilTeX`Private`opts, 
          BlankNullSequence[]]] :> 
       Module[{VilTeX`Private`tikzCode, VilTeX`Private`fullDocument, 
          VilTeX`Private`downloadPath, VilTeX`Private`folderName, 
          VilTeX`Private`folderPath, VilTeX`Private`vertices, 
          VilTeX`Private`edges, VilTeX`Private`vertexCoords, 
          VilTeX`Private`edgeWeightRules, VilTeX`Private`vertexSize = 0.1, 
          VilTeX`Private`edgeThickness = "thick", VilTeX`Private`vertexColor = 
          "blue", VilTeX`Private`edgeColor = "black", 
          VilTeX`Private`vertexLabels = True, VilTeX`Private`directed = 
          Automatic, VilTeX`Private`nodeShape = "circle", VilTeX`Private`grid = 
          False, VilTeX`Private`showAxes = False, VilTeX`Private`xmin = 
          Automatic, VilTeX`Private`xmax = Automatic, VilTeX`Private`ymin = 
          Automatic, VilTeX`Private`ymax = Automatic, 
          VilTeX`Private`vertexLabelColor = "black", VilTeX`Private`edgeStyle = 
          "solid", VilTeX`Private`showEdgeWeights = True, 
          VilTeX`Private`edgeWeightColor = "red", 
          VilTeX`Private`edgeWeightSize = "small", VilTeX`Private`graphScale = 
          Automatic, VilTeX`Private`formatNum, VilTeX`Private`optionsList, 
          VilTeX`Private`graphLayout, VilTeX`Private`originalDirected}, 
         Clear[VilTeX`Private`cleanVertexName, VilTeX`Private`SymbolQ, 
           Removed["a"], 
           Removed["b"], 
           Removed["c"], 
           Removed["d"], 
           Removed["e"]]; If[
           Not[
            GraphQ[VilTeX`Private`graph]], 
           Return[$Failed]]; If[
           Not[
            StringQ[VilTeX`Private`filename]], 
           Return[$Failed]]; If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Return[$Failed]]; 
         VilTeX`Private`optionsList = {VilTeX`Private`opts}; 
         If[Length[VilTeX`Private`optionsList] > 0, Do[
             If[
              MatchQ[
               Part[VilTeX`Private`optionsList, VilTeX`Private`i], 
               Blank[String] -> Blank[]], 
              Module[{VilTeX`Private`key = 
                 Part[VilTeX`Private`optionsList, VilTeX`Private`i, 1], 
                 VilTeX`Private`value = 
                 Part[VilTeX`Private`optionsList, VilTeX`Private`i, 2]}, 
                Switch[VilTeX`Private`key, "VertexSize", 
                  VilTeX`Private`vertexSize = VilTeX`Private`value, 
                  "EdgeThickness", VilTeX`Private`edgeThickness = 
                  VilTeX`Private`value, "VertexColor", 
                  VilTeX`Private`vertexColor = VilTeX`Private`value, 
                  "EdgeColor", VilTeX`Private`edgeColor = 
                  VilTeX`Private`value, "VertexLabels", 
                  VilTeX`Private`vertexLabels = VilTeX`Private`value, 
                  "Directed", VilTeX`Private`directed = VilTeX`Private`value, 
                  "NodeShape", VilTeX`Private`nodeShape = 
                  VilTeX`Private`value, "Grid", VilTeX`Private`grid = 
                  VilTeX`Private`value, "ShowAxes", VilTeX`Private`showAxes = 
                  VilTeX`Private`value, "XMin", VilTeX`Private`xmin = 
                  VilTeX`Private`value, "XMax", VilTeX`Private`xmax = 
                  VilTeX`Private`value, "YMin", VilTeX`Private`ymin = 
                  VilTeX`Private`value, "YMax", VilTeX`Private`ymax = 
                  VilTeX`Private`value, "VertexLabelColor", 
                  VilTeX`Private`vertexLabelColor = VilTeX`Private`value, 
                  "EdgeStyle", VilTeX`Private`edgeStyle = 
                  VilTeX`Private`value, "ShowEdgeWeights", 
                  VilTeX`Private`showEdgeWeights = VilTeX`Private`value, 
                  "EdgeWeightColor", VilTeX`Private`edgeWeightColor = 
                  VilTeX`Private`value, "EdgeWeightSize", 
                  VilTeX`Private`edgeWeightSize = VilTeX`Private`value, 
                  "GraphScale", VilTeX`Private`graphScale = 
                  VilTeX`Private`value, 
                  Blank[], Null]; Null]; Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`optionsList]}]; Null]; 
         VilTeX`Private`formatNum[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := If[
            NumericQ[VilTeX`Private`x], 
            ToString[
             Round[
              N[VilTeX`Private`x], 0.001], InputForm], "0"]; 
         VilTeX`Private`cleanVertexName[
            Pattern[VilTeX`Private`v, 
             Blank[]]] := 
          Module[{VilTeX`Private`cleanName}, 
            VilTeX`Private`cleanName = ToString[VilTeX`Private`v]; 
            VilTeX`Private`cleanName = 
             StringReplace[
              VilTeX`Private`cleanName, {
               "\\" -> "\\textbackslash ", "{" -> "\\{", "}" -> "\\}", "$" -> 
                "\\$", "&" -> "\\&", "%" -> "\\%", "#" -> "\\#", "^" -> 
                "\\textasciicircum ", "_" -> "\\_", "~" -> 
                "\\textasciitilde "}]; VilTeX`Private`cleanName]; 
         VilTeX`Private`vertices = VertexList[VilTeX`Private`graph]; 
         VilTeX`Private`vertices = Select[VilTeX`Private`vertices, And[
             Not[
              MatchQ[#, 
               Alternatives[Null, 
                Blank[Graph], 
                Blank[Graphics]]]], 
             Or[
              NumericQ[#], 
              VilTeX`Private`SymbolQ[#], 
              StringQ[#], 
              AtomQ[#]]]& ]; 
         If[Length[VilTeX`Private`vertices] == 0, VilTeX`Private`vertices = {
              Removed["a"], 
              Removed["b"], 
              Removed["c"], 
              Removed["d"], 
              Removed["e"]}; Null]; VilTeX`Private`originalDirected = False; 
         If[VilTeX`Private`directed === Automatic, 
           Module[{VilTeX`Private`isDirectedQ}, 
             VilTeX`Private`isDirectedQ = Quiet[
                Check[
                 DirectedGraphQ[VilTeX`Private`graph], False]]; If[
               TrueQ[VilTeX`Private`isDirectedQ], 
               VilTeX`Private`originalDirected = True]; Null]; If[
             Not[VilTeX`Private`originalDirected], 
             Module[{VilTeX`Private`edgeTypes}, 
               VilTeX`Private`edgeTypes = Quiet[
                  Check[
                   EdgeList[VilTeX`Private`graph], {}]]; If[
                 And[Length[VilTeX`Private`edgeTypes] > 0, 
                  AnyTrue[VilTeX`Private`edgeTypes, MatchQ[#, 
                    DirectedEdge[
                    Blank[], 
                    Blank[]]]& ]], VilTeX`Private`originalDirected = True]; 
               Null]; Null]; 
           VilTeX`Private`directed = VilTeX`Private`originalDirected; Null]; 
         If[VilTeX`Private`directed === True, VilTeX`Private`originalDirected = 
           True]; VilTeX`Private`edges = Quiet[
            Check[
             EdgeList[VilTeX`Private`graph], {}]]; 
         VilTeX`Private`edges = Select[VilTeX`Private`edges, And[
             MatchQ[#, 
              Alternatives[
               UndirectedEdge[
                Blank[], 
                Blank[]], 
               DirectedEdge[
                Blank[], 
                Blank[]]]], 
             MemberQ[VilTeX`Private`vertices, 
              Part[#, 1]], 
             MemberQ[VilTeX`Private`vertices, 
              Part[#, 2]]]& ]; If[Length[VilTeX`Private`edges] == 0, 
           
           Module[{VilTeX`Private`edgeData, VilTeX`Private`indexBasedEdges}, 
            VilTeX`Private`edgeData = Cases[VilTeX`Private`graph, {
                Repeated[{
                  Blank[Integer], 
                  Blank[Integer]}]}, Infinity]; If[
              And[
              Length[VilTeX`Private`edgeData] > 0, 
               Length[VilTeX`Private`vertices] >= Max[
                 Flatten[VilTeX`Private`edgeData]]], 
              VilTeX`Private`indexBasedEdges = 
               Flatten[VilTeX`Private`edgeData, 1]; 
              VilTeX`Private`edges = Map[If[VilTeX`Private`originalDirected, 
                  DirectedEdge[
                   Part[VilTeX`Private`vertices, 
                    Part[#, 1]], 
                   Part[VilTeX`Private`vertices, 
                    Part[#, 2]]], 
                  UndirectedEdge[
                   Part[VilTeX`Private`vertices, 
                    Part[#, 1]], 
                   Part[VilTeX`Private`vertices, 
                    Part[#, 2]]]]& , VilTeX`Private`indexBasedEdges]]]]; If[
           And[
           Length[VilTeX`Private`edges] == 0, Length[VilTeX`Private`vertices] >= 
            2], VilTeX`Private`edges = {
             If[VilTeX`Private`originalDirected, 
              DirectedEdge[
               Part[VilTeX`Private`vertices, 1], 
               Part[VilTeX`Private`vertices, 2]], 
              UndirectedEdge[
               Part[VilTeX`Private`vertices, 1], 
               Part[VilTeX`Private`vertices, 2]]]}]; 
         VilTeX`Private`edgeWeightRules = <||>; 
         Module[{VilTeX`Private`edgeWeights = Quiet[
              PropertyValue[VilTeX`Private`graph, EdgeWeight]]}, If[
             And[VilTeX`Private`edgeWeights =!= $Failed, 
              ListQ[VilTeX`Private`edgeWeights], 
              Length[VilTeX`Private`edgeWeights] == 
              Length[VilTeX`Private`edges]], 
             VilTeX`Private`edgeWeightRules = <|
                Thread[VilTeX`Private`edges -> VilTeX`Private`edgeWeights]|>; 
             Null]; Null]; 
         If[Length[VilTeX`Private`edgeWeightRules] == 0, 
           Module[{VilTeX`Private`graphOptions, 
              VilTeX`Private`edgeLabelsOption, VilTeX`Private`weightRules}, 
             VilTeX`Private`graphOptions = Options[VilTeX`Private`graph]; 
             VilTeX`Private`edgeLabelsOption = 
              Cases[VilTeX`Private`graphOptions, 
                EdgeLabels -> (Pattern[VilTeX`Private`rules, 
                   Blank[]] :> VilTeX`Private`rules)]; 
             If[Length[VilTeX`Private`edgeLabelsOption] > 0, 
               Module[{
                 VilTeX`Private`edgeLabelsData = 
                  Part[VilTeX`Private`edgeLabelsOption, 1]}, If[
                   ListQ[VilTeX`Private`edgeLabelsData], 
                   VilTeX`Private`weightRules = 
                    Select[VilTeX`Private`edgeLabelsData, NumericQ[
                    Part[#, 2]]& ]; 
                   If[Length[VilTeX`Private`weightRules] > 0, 
                    VilTeX`Private`edgeWeightRules = <|
                    VilTeX`Private`weightRules|>; Null]; Null]; Null]; Null]; 
             Null]; Null]; 
         If[Length[VilTeX`Private`edgeWeightRules] == 0, 
           Module[{VilTeX`Private`edgeWeightData}, 
             VilTeX`Private`edgeWeightData = 
              Cases[VilTeX`Private`graph, 
                EdgeWeight -> (Pattern[VilTeX`Private`weights, 
                   Blank[]] :> VilTeX`Private`weights), Infinity]; If[
               And[Length[VilTeX`Private`edgeWeightData] > 0, 
                ListQ[
                 Part[VilTeX`Private`edgeWeightData, 1]], Length[
                  Part[VilTeX`Private`edgeWeightData, 1]] == 
                Length[VilTeX`Private`edges]], 
               VilTeX`Private`edgeWeightRules = <|
                  Thread[
                  VilTeX`Private`edges -> 
                   Part[VilTeX`Private`edgeWeightData, 1]]|>; Null]; Null]; 
           Null]; Module[{VilTeX`Private`existingCoords}, 
           VilTeX`Private`existingCoords = Quiet[
              PropertyValue[VilTeX`Private`graph, VertexCoordinates]]; If[
             Or[VilTeX`Private`existingCoords === $Failed, 
              Not[
               ListQ[VilTeX`Private`existingCoords]], 
              Length[VilTeX`Private`existingCoords] != 
              Length[VilTeX`Private`vertices]], 
             Module[{
               VilTeX`Private`graphOptions, VilTeX`Private`coordsOption}, 
               VilTeX`Private`graphOptions = Options[VilTeX`Private`graph]; 
               VilTeX`Private`coordsOption = 
                Cases[VilTeX`Private`graphOptions, 
                  VertexCoordinates -> (Pattern[VilTeX`Private`coords, 
                    Blank[]] :> VilTeX`Private`coords)]; If[
                 And[Length[VilTeX`Private`coordsOption] > 0, 
                  ListQ[
                   Part[VilTeX`Private`coordsOption, 1]], Length[
                    Part[VilTeX`Private`coordsOption, 1]] == 
                  Length[VilTeX`Private`vertices]], 
                 VilTeX`Private`existingCoords = 
                  Part[VilTeX`Private`coordsOption, 1]; Null, 
                 VilTeX`Private`existingCoords = $Failed; Null]; Null]; Null]; 
           If[
             And[
              ListQ[VilTeX`Private`existingCoords], 
              Length[VilTeX`Private`existingCoords] == 
              Length[VilTeX`Private`vertices]], 
             VilTeX`Private`graphLayout = VilTeX`Private`existingCoords; Null,
              VilTeX`Private`graphLayout = Quiet[
                GraphEmbedding[
                 Graph[VilTeX`Private`vertices, VilTeX`Private`edges]]]; If[
               Or[
               VilTeX`Private`graphLayout === $Failed, 
                Length[VilTeX`Private`graphLayout] != 
                Length[VilTeX`Private`vertices]], 
               Module[{
                 VilTeX`Private`n = Length[VilTeX`Private`vertices], 
                  VilTeX`Private`angle}, 
                 VilTeX`Private`graphLayout = 
                  Table[VilTeX`Private`angle = 
                    2 Pi ((VilTeX`Private`i - 1)/VilTeX`Private`n); {
                    2 Cos[VilTeX`Private`angle], 2 
                    Sin[VilTeX`Private`angle]}, {
                    VilTeX`Private`i, VilTeX`Private`n}]; Null]; Null]; Null]; 
           Null]; VilTeX`Private`vertexCoords = <|
            Thread[VilTeX`Private`vertices -> VilTeX`Private`graphLayout]|>; 
         Module[{VilTeX`Private`allCoords = 
            Values[VilTeX`Private`vertexCoords]}, 
           If[Length[VilTeX`Private`allCoords] > 0, 
             If[VilTeX`Private`xmin === Automatic, VilTeX`Private`xmin = Min[
                  Part[VilTeX`Private`allCoords, All, 1]] - 0.5]; 
             If[VilTeX`Private`xmax === Automatic, VilTeX`Private`xmax = Max[
                  Part[VilTeX`Private`allCoords, All, 1]] + 0.5]; 
             If[VilTeX`Private`ymin === Automatic, VilTeX`Private`ymin = Min[
                  Part[VilTeX`Private`allCoords, All, 2]] - 0.5]; 
             If[VilTeX`Private`ymax === Automatic, VilTeX`Private`ymax = Max[
                  Part[VilTeX`Private`allCoords, All, 2]] + 0.5]; Null, 
             If[VilTeX`Private`xmin === Automatic, VilTeX`Private`xmin = -3]; 
             If[VilTeX`Private`xmax === Automatic, VilTeX`Private`xmax = 3]; 
             If[VilTeX`Private`ymin === Automatic, VilTeX`Private`ymin = -3]; 
             If[VilTeX`Private`ymax === Automatic, VilTeX`Private`ymax = 3]; 
             Null]; Null]; 
         Module[{VilTeX`Private`xRange = 
            VilTeX`Private`xmax - VilTeX`Private`xmin, VilTeX`Private`yRange = 
            VilTeX`Private`ymax - VilTeX`Private`ymin, 
            VilTeX`Private`targetSize = 8, VilTeX`Private`scaleX, 
            VilTeX`Private`scaleY, VilTeX`Private`finalScale}, 
           If[VilTeX`Private`graphScale === Automatic, 
             VilTeX`Private`scaleX = 
              VilTeX`Private`targetSize/Max[VilTeX`Private`xRange, 0.1]; 
             VilTeX`Private`scaleY = 
              VilTeX`Private`targetSize/Max[VilTeX`Private`yRange, 0.1]; 
             VilTeX`Private`finalScale = 
              Min[VilTeX`Private`scaleX, VilTeX`Private`scaleY, 1.5]; 
             VilTeX`Private`finalScale = Max[VilTeX`Private`finalScale, 0.3]; 
             Null, VilTeX`Private`finalScale = VilTeX`Private`graphScale; 
             Null]; VilTeX`Private`tikzCode = 
            "\\begin{tikzpicture}[scale=" <> ToString[
               N[VilTeX`Private`finalScale]] <> "]\n"; Null]; If[
           Or[VilTeX`Private`showAxes, VilTeX`Private`grid], 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "\\begin{axis}[\n"; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "  xlabel={$x$}, ylabel={$y$},\n"; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "  xmin=" <> 
             VilTeX`Private`formatNum[VilTeX`Private`xmin] <> ", xmax=" <> 
             VilTeX`Private`formatNum[VilTeX`Private`xmax] <> ",\n"; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "  ymin=" <> 
             VilTeX`Private`formatNum[VilTeX`Private`ymin] <> ", ymax=" <> 
             VilTeX`Private`formatNum[VilTeX`Private`ymax] <> ",\n"; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "  width=8cm, height=6cm,\n"; 
           If[VilTeX`Private`grid, VilTeX`Private`tikzCode = 
             VilTeX`Private`tikzCode <> "  grid=major,\n"]; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "  axis lines=" <> 
             If[VilTeX`Private`showAxes, "center", "none"] <> ",\n"; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> 
             "  tick label style={/pgf/number format/fixed},\n"; 
           VilTeX`Private`tikzCode = 
            VilTeX`Private`tikzCode <> "  scaled ticks=false\n]\n"; Null]; 
         Do[
           
           Module[{VilTeX`Private`edge, VilTeX`Private`fromVertex, 
             VilTeX`Private`toVertex, VilTeX`Private`fromCoord, 
             VilTeX`Private`toCoord, VilTeX`Private`arrowStyle, 
             VilTeX`Private`lineStyle}, 
            VilTeX`Private`edge = 
             Part[VilTeX`Private`edges, VilTeX`Private`i]; 
            VilTeX`Private`fromVertex = Part[VilTeX`Private`edge, 1]; 
            VilTeX`Private`toVertex = Part[VilTeX`Private`edge, 2]; If[
              And[
               KeyExistsQ[
               VilTeX`Private`vertexCoords, VilTeX`Private`fromVertex], 
               KeyExistsQ[
               VilTeX`Private`vertexCoords, VilTeX`Private`toVertex]], 
              VilTeX`Private`fromCoord = 
               VilTeX`Private`vertexCoords[VilTeX`Private`fromVertex]; 
              VilTeX`Private`toCoord = 
               VilTeX`Private`vertexCoords[VilTeX`Private`toVertex]; 
              VilTeX`Private`arrowStyle = ""; If[
                Or[
                VilTeX`Private`originalDirected, VilTeX`Private`directed === 
                 True], 
                If[
                 MatchQ[VilTeX`Private`edge, 
                  DirectedEdge[
                   Blank[], 
                   Blank[]]], VilTeX`Private`arrowStyle = "-latex"]]; 
              VilTeX`Private`lineStyle = 
               Switch[VilTeX`Private`edgeStyle, "dashed", "dashed", "dotted", 
                 "dotted", "thick", "very thick", 
                 Blank[], ""]; 
              Module[{VilTeX`Private`useAxisCoords = 
                 Or[VilTeX`Private`showAxes, VilTeX`Private`grid], 
                 VilTeX`Private`drawOptions}, 
                VilTeX`Private`drawOptions = 
                 VilTeX`Private`edgeColor <> ", " <> 
                  VilTeX`Private`edgeThickness; 
                If[VilTeX`Private`lineStyle != "", VilTeX`Private`drawOptions = 
                  VilTeX`Private`drawOptions <> ", " <> 
                   VilTeX`Private`lineStyle]; 
                If[VilTeX`Private`arrowStyle != "", 
                  VilTeX`Private`drawOptions = 
                  VilTeX`Private`drawOptions <> ", " <> 
                   VilTeX`Private`arrowStyle]; 
                VilTeX`Private`tikzCode = 
                 VilTeX`Private`tikzCode <> "\\draw[" <> 
                  VilTeX`Private`drawOptions <> "]"; 
                If[VilTeX`Private`useAxisCoords, 
                  VilTeX`Private`tikzCode = 
                   VilTeX`Private`tikzCode <> " (axis cs:" <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`fromCoord, 1]] <> "," <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`fromCoord, 2]] <> ") -- (axis cs:" <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`toCoord, 1]] <> "," <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`toCoord, 2]] <> ");\n"; Null, 
                  VilTeX`Private`tikzCode = 
                   VilTeX`Private`tikzCode <> " (" <> VilTeX`Private`formatNum[
                    Part[VilTeX`Private`fromCoord, 1]] <> "," <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`fromCoord, 2]] <> ") -- (" <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`toCoord, 1]] <> "," <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`toCoord, 2]] <> ");\n"; Null]; Null]; 
              If[VilTeX`Private`showEdgeWeights, 
                Module[{
                  VilTeX`Private`edgeWeight = Undefined, 
                   VilTeX`Private`searchKeys}, 
                  VilTeX`Private`searchKeys = {VilTeX`Private`edge, 
                    DirectedEdge[
                    VilTeX`Private`fromVertex, VilTeX`Private`toVertex], 
                    UndirectedEdge[
                    VilTeX`Private`fromVertex, VilTeX`Private`toVertex]}; Do[
                    If[
                    KeyExistsQ[VilTeX`Private`edgeWeightRules, 
                    Part[VilTeX`Private`searchKeys, VilTeX`Private`j]], 
                    VilTeX`Private`edgeWeight = VilTeX`Private`edgeWeightRules[
                    Part[VilTeX`Private`searchKeys, VilTeX`Private`j]]; 
                    Break[]; Null], {VilTeX`Private`j, 
                    Length[VilTeX`Private`searchKeys]}]; If[
                    And[VilTeX`Private`edgeWeight =!= Undefined, 
                    NumericQ[VilTeX`Private`edgeWeight]], 
                    Module[{
                    VilTeX`Private`midPointX, VilTeX`Private`midPointY, 
                    VilTeX`Private`weightLabel, VilTeX`Private`useAxisCoords = 
                    Or[VilTeX`Private`showAxes, VilTeX`Private`grid]}, 
                    VilTeX`Private`midPointX = (
                    Part[VilTeX`Private`fromCoord, 1] + 
                    Part[VilTeX`Private`toCoord, 1])/2; 
                    VilTeX`Private`midPointY = (
                    Part[VilTeX`Private`fromCoord, 2] + 
                    Part[VilTeX`Private`toCoord, 2])/2; 
                    VilTeX`Private`weightLabel = 
                    ToString[VilTeX`Private`edgeWeight]; 
                    If[VilTeX`Private`useAxisCoords, 
                    VilTeX`Private`tikzCode = 
                    VilTeX`Private`tikzCode <> 
                    "\\node[fill=white, inner sep=1pt, text=" <> 
                    VilTeX`Private`edgeWeightColor <> "] at (axis cs:" <> 
                    VilTeX`Private`formatNum[VilTeX`Private`midPointX] <> "," <> 
                    VilTeX`Private`formatNum[VilTeX`Private`midPointY] <> 
                    ") {\\small $" <> VilTeX`Private`weightLabel <> "$};\n"; 
                    Null, VilTeX`Private`tikzCode = 
                    VilTeX`Private`tikzCode <> 
                    "\\node[fill=white, inner sep=1pt, text=" <> 
                    VilTeX`Private`edgeWeightColor <> "] at (" <> 
                    VilTeX`Private`formatNum[VilTeX`Private`midPointX] <> "," <> 
                    VilTeX`Private`formatNum[VilTeX`Private`midPointY] <> 
                    ") {\\small $" <> VilTeX`Private`weightLabel <> "$};\n"; 
                    Null]; Null]; Null]; Null]; Null]; Null]; Null], {
           VilTeX`Private`i, 
            Length[VilTeX`Private`edges]}]; Do[
           
           Module[{VilTeX`Private`vertex, VilTeX`Private`coord, 
             VilTeX`Private`tikzNodeShape, VilTeX`Private`vertexLabel}, 
            VilTeX`Private`vertex = 
             Part[VilTeX`Private`vertices, VilTeX`Private`i]; 
            VilTeX`Private`coord = 
             VilTeX`Private`vertexCoords[VilTeX`Private`vertex]; 
            VilTeX`Private`tikzNodeShape = 
             Switch[VilTeX`Private`nodeShape, "square", "rectangle", 
               "triangle", "regular polygon, regular polygon sides=3", 
               Blank[], "circle"]; 
            VilTeX`Private`vertexLabel = 
             VilTeX`Private`cleanVertexName[VilTeX`Private`vertex]; 
            Module[{VilTeX`Private`useAxisCoords = 
               Or[VilTeX`Private`showAxes, VilTeX`Private`grid]}, 
              If[VilTeX`Private`useAxisCoords, 
                VilTeX`Private`tikzCode = 
                 VilTeX`Private`tikzCode <> "\\node[" <> 
                  VilTeX`Private`tikzNodeShape <> ", fill=" <> 
                  VilTeX`Private`vertexColor <> ", draw=black, minimum size=" <> 
                  ToString[VilTeX`Private`vertexSize] <> "cm] (v" <> 
                  ToString[VilTeX`Private`i] <> ") at (axis cs:" <> 
                  VilTeX`Private`formatNum[
                    Part[VilTeX`Private`coord, 1]] <> "," <> 
                  VilTeX`Private`formatNum[
                    Part[VilTeX`Private`coord, 2]] <> ") {};\n"; Null, 
                VilTeX`Private`tikzCode = 
                 VilTeX`Private`tikzCode <> "\\node[" <> 
                  VilTeX`Private`tikzNodeShape <> ", fill=" <> 
                  VilTeX`Private`vertexColor <> ", draw=black, minimum size=" <> 
                  ToString[VilTeX`Private`vertexSize] <> "cm] (v" <> 
                  ToString[VilTeX`Private`i] <> ") at (" <> 
                  VilTeX`Private`formatNum[
                    Part[VilTeX`Private`coord, 1]] <> "," <> 
                  VilTeX`Private`formatNum[
                    Part[VilTeX`Private`coord, 2]] <> ") {};\n"; Null]; 
              If[VilTeX`Private`vertexLabels, 
                If[VilTeX`Private`useAxisCoords, 
                  VilTeX`Private`tikzCode = 
                   VilTeX`Private`tikzCode <> "\\node[text=" <> 
                    VilTeX`Private`vertexLabelColor <> "] at (axis cs:" <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`coord, 1]] <> "," <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`coord, 2]] <> ") {$" <> 
                    VilTeX`Private`vertexLabel <> "$};\n"; Null, 
                  VilTeX`Private`tikzCode = 
                   VilTeX`Private`tikzCode <> "\\node[text=" <> 
                    VilTeX`Private`vertexLabelColor <> "] at (" <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`coord, 1]] <> "," <> 
                    VilTeX`Private`formatNum[
                    Part[VilTeX`Private`coord, 2]] <> ") {$" <> 
                    VilTeX`Private`vertexLabel <> "$};\n"; Null]; Null]; 
              Null]; Null], {VilTeX`Private`i, 
            Length[VilTeX`Private`vertices]}]; If[
           Or[VilTeX`Private`showAxes, VilTeX`Private`grid], 
           VilTeX`Private`tikzCode = 
           VilTeX`Private`tikzCode <> "\\end{axis}\n"]; 
         VilTeX`Private`tikzCode = 
          VilTeX`Private`tikzCode <> "\\end{tikzpicture}"; 
         VilTeX`Private`fullDocument = 
          "\\documentclass[border=5mm]{standalone}\n" <> 
           "\\usepackage{tikz}\n" <> "\\usepackage{xcolor}\n" <> If[
             Or[VilTeX`Private`showAxes, VilTeX`Private`grid], 
             "\\usepackage{pgfplots}\n\\pgfplotsset{compat=1.18}\n", ""] <> 
           "\\usetikzlibrary{shapes.geometric, arrows}\n" <> 
           "\\usepackage{amsmath}\n" <> "\\usepackage{amssymb}\n" <> 
           "\n% Definir colores personalizados\n" <> 
           "\\definecolor{darkblue}{RGB}{0,0,139}\n" <> 
           "\\definecolor{lightblue}{RGB}{173,216,230}\n" <> 
           "\\definecolor{darkgreen}{RGB}{0,100,0}\n" <> 
           "\\definecolor{lightgreen}{RGB}{144,238,144}\n" <> 
           "\\definecolor{darkred}{RGB}{139,0,0}\n" <> 
           "\\definecolor{lightgray}{RGB}{211,211,211}\n" <> 
           "\\definecolor{darkgray}{RGB}{169,169,169}\n" <> 
           "\\definecolor{orange}{RGB}{255,165,0}\n" <> 
           "\\definecolor{purple}{RGB}{128,0,128}\n" <> 
           "\\definecolor{pink}{RGB}{255,192,203}\n" <> 
           "\n\\begin{document}\n" <> VilTeX`Private`tikzCode <> 
           "\n\\end{document}"; 
         VilTeX`Private`folderName = FileBaseName[VilTeX`Private`filename]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`ExportGraphToTikZ"|>, False]]], "Output",
 CellChangeTimes->{3.967056320489688*^9, 3.967059991639286*^9, 
  3.967106319470076*^9, 3.967109225538306*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"ad3867eb-5412-4b25-86bd-4b6ae6f4b9bb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 1: uso b\[AAcute]sico", "Subsection",
 CellChangeTimes->{{3.9670547588374987`*^9, 
  3.967054793264592*^9}},ExpressionUUID->"e490c9e0-d08b-429b-ba27-\
9710ab2bc5a3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo1", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"dirigido", "->", "True"}], ",", 
    RowBox[{"shape", "->", "True"}], ",", 
    RowBox[{"radio", "->", "0.03"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo1", ",", "\"\<grafo1.tex\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967054806735799*^9, 3.967054838196877*^9}, 
   3.967055238117103*^9, 3.967056189773569*^9, {3.967056717858882*^9, 
   3.967056718342164*^9}, {3.9670583593426228`*^9, 3.967058382668729*^9}, {
   3.96705841552114*^9, 3.9670584453703413`*^9}, 3.967060005011612*^9, {
   3.967100818034165*^9, 3.9671008675282383`*^9}, {3.9671009029433117`*^9, 
   3.9671009031094847`*^9}, {3.96710118057724*^9, 3.9671011926551943`*^9}, {
   3.967104234090968*^9, 3.967104238918701*^9}, {3.967104501656126*^9, 
   3.9671045130257196`*^9}, {3.9671051675155067`*^9, 
   3.9671051937494783`*^9}, {3.967105681821992*^9, 3.967105698459688*^9}, {
   3.9671058281675053`*^9, 3.967105837183234*^9}, {3.967106354718471*^9, 
   3.96710642931777*^9}, {3.967109289317494*^9, 3.9671093318770227`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"00da87b3-93cf-43d1-8197-d2272951b8e0"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3}, {{{1, 2}, {2, 3}, {3, 1}}, Null}, {
      ImagePadding -> 10, VertexShapeFunction -> {{White, 
          EdgeForm[Black], 
          Disk[#, 
           OptionValue[
           VilCretas`Grafo, {
            VilCretas`dirigido -> True, VilCretas`shape -> True, 
             VilCretas`radio -> 0.03}, VilCretas`radio]], Black, 
          Text[#2, #]}& }}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], 
        ArrowBox[{{{-0.8660254037844384, -0.4999999999999994}, {
         0.8660254037844389, -0.5000000000000012}}, {{
         0.8660254037844389, -0.5000000000000012}, {1.8369701987210297`*^-16, 
         1.}}, {{1.8369701987210297`*^-16, 
         1.}, {-0.8660254037844384, -0.4999999999999994}}}, 
         0.020399597244776385`]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{-0.8660254037844384, -0.4999999999999994}, 0.03], 
         {GrayLevel[0], 
          InsetBox["1", {-0.8660254037844384, -0.4999999999999994}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{0.8660254037844389, -0.5000000000000012}, 0.03], 
         {GrayLevel[0], 
          InsetBox["2", {0.8660254037844389, -0.5000000000000012}]}}, 
        {GrayLevel[1], EdgeForm[GrayLevel[0]], 
         DiskBox[{1.8369701987210297`*^-16, 1.}, 0.03], 
         {GrayLevel[0], InsetBox["3", {1.8369701987210297*^-16, 1.}]}}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.967056249009768*^9, 3.9670567187416058`*^9, {3.9670583304556007`*^9, 
   3.9670583598288918`*^9}, {3.9670584165797977`*^9, 
   3.9670584463664637`*^9}, {3.967060000608227*^9, 3.967060018365594*^9}, 
   3.967100780440452*^9, {3.967100823663138*^9, 3.9671008687441998`*^9}, 
   3.9671009044967527`*^9, {3.967100978054695*^9, 3.9671010262267523`*^9}, 
   3.9671010932214537`*^9, {3.967101181138741*^9, 3.967101193433182*^9}, {
   3.967104482272064*^9, 3.967104513895352*^9}, {3.9671051492289762`*^9, 
   3.967105194658888*^9}, {3.9671056668797693`*^9, 3.967105698888523*^9}, {
   3.9671058207099123`*^9, 3.9671058380039787`*^9}, {3.9671063960681543`*^9, 
   3.9671064300937557`*^9}, 3.967109264931497*^9, {3.9671093017787933`*^9, 
   3.967109332792445*^9}},
 CellLabel->"Out[16]=",ExpressionUUID->"7c34180f-171c-4bb7-ac61-658e8a12fdf4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.9671093327976007`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"e5ff4ab8-7a6a-435a-bbc9-e6602ebf9acd"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.967109332798377*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"4ca4c1f1-63c6-48bd-8235-6c23ea5a829d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.967109332799038*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"1d95b435-51b5-47c8-83af-312751ddea56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.9671093327994633`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"1dd51557-0f1f-4d33-a2f3-3ef7e7f2b1d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.967109332799878*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"317282ba-e256-4024-a539-fbbddaabfad4"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.9671093328795443`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"b8226142-57ee-41ae-b7fd-58d6d107f081"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.967109333886093*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"8a55cd08-f216-4049-8ccc-308594a42915"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo1/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo1/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.967109333889138*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"cb9d4ab8-c1bb-4852-b77c-788344459eef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo1\"\>"}],
  SequenceForm["Archivo: ", "grafo1"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.967109333891029*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"0bd3b650-d18c-4663-92bc-d28fa6755918"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.967109334358482*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"47fe4d89-0bd7-4426-be21-eea92a7c50b3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo1/grafo1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo1/grafo1.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106396090211*^9, 3.9671064300984583`*^9}, 
   3.967109264952359*^9, {3.967109301784411*^9, 3.967109334359017*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[16]:=",ExpressionUUID->"0ca80475-ce21-4365-8113-aa9c5c5123fb"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo1/grafo1.pdf\"\>\
"], "Output",
 CellChangeTimes->{
  3.967056249009768*^9, 3.9670567187416058`*^9, {3.9670583304556007`*^9, 
   3.9670583598288918`*^9}, {3.9670584165797977`*^9, 
   3.9670584463664637`*^9}, {3.967060000608227*^9, 3.967060018365594*^9}, 
   3.967100780440452*^9, {3.967100823663138*^9, 3.9671008687441998`*^9}, 
   3.9671009044967527`*^9, {3.967100978054695*^9, 3.9671010262267523`*^9}, 
   3.9671010932214537`*^9, {3.967101181138741*^9, 3.967101193433182*^9}, {
   3.967104482272064*^9, 3.967104513895352*^9}, {3.9671051492289762`*^9, 
   3.967105194658888*^9}, {3.9671056668797693`*^9, 3.967105698888523*^9}, {
   3.9671058207099123`*^9, 3.9671058380039787`*^9}, {3.9671063960681543`*^9, 
   3.9671064300937557`*^9}, 3.967109264931497*^9, {3.9671093017787933`*^9, 
   3.967109334370905*^9}},
 CellLabel->"Out[18]=",ExpressionUUID->"9712e70b-223f-4bda-b200-f4188962a5ba"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: grafo aleatorio", "Subsection",
 CellChangeTimes->{{3.967054727412339*^9, 3.967054729722788*^9}, {
  3.967054842409219*^9, 
  3.967054847236347*^9}},ExpressionUUID->"a80fe639-eef2-45f4-96f5-\
fa98d53d1a10"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo2", "=", 
  RowBox[{"GrafoRandom", "[", 
   RowBox[{"8", ",", "6", ",", 
    RowBox[{"letras", "->", "True"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo2", ",", "\"\<grafo2.tex\>\"", ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<white\>\""}], ",", 
    RowBox[{"\"\<GraphScale\>\"", "->", "0.5"}], 
    RowBox[{"(*", 
     RowBox[{
     "entre", " ", "menor", " ", "sea", " ", "la", " ", "escala", " ", 
      "m\[AAcute]s", " ", "grande", " ", "se", " ", "ve", " ", "en", " ", 
      "LaTeX"}], "*)"}], ",", 
    RowBox[{"\"\<NodeShape\>\"", "->", "\"\<square\>\""}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967054915182334*^9, 3.967054920958385*^9}, {
   3.967054976921221*^9, 3.967054977206831*^9}, {3.967055196658677*^9, 
   3.96705522791706*^9}, 3.967056195791131*^9, {3.967056362065894*^9, 
   3.9670564404325933`*^9}, {3.967056482837738*^9, 3.967056568814228*^9}, {
   3.967056728076558*^9, 3.9670567394893923`*^9}, 3.9670584545358686`*^9, 
   3.967060037022341*^9, {3.967105227437366*^9, 3.967105227849914*^9}, {
   3.967105876142939*^9, 3.967105878225078*^9}, {3.9671064841408463`*^9, 
   3.9671064892171087`*^9}, {3.9671065199269238`*^9, 3.967106533451062*^9}, {
   3.967106822770446*^9, 3.967106850353388*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"c4aa9953-6015-4210-afb3-cc2ee6f5eb12"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`e, $CellContext`f, $CellContext`g, $CellContext`h}, {
      Null, {{1, 6}, {1, 8}, {2, 3}, {5, 6}, {5, 8}, {6, 7}}}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[0.], 
        ArrowBox[{{{2.132501908680075, -1.3324246262738693`}, {
         1.266594600610184, -0.7662172269307757}}, {{
         2.132501908680075, -1.3324246262738693`}, {
         2.8674945778142513`, -0.7662109312456952}}, {{
         1.2000061232341586`, -1.7324368727421864`}, {
         0.20000612323415856`, -1.7324368727421864`}}, {{
         2.1324941709203804`, -0.20000612323415856`}, {
         1.266594600610184, -0.7662172269307757}}, {{
         2.1324941709203804`, -0.20000612323415856`}, {
         2.8674945778142513`, -0.7662109312456952}}, {{
         1.266594600610184, -0.7662172269307757}, {
         0.20000612323415856`, -0.7662143496480989}}}, 0.0278065427967146]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.132501908680075, -1.3324246262738693`}, 
          0.0278065427967146], 
         InsetBox["a", 
          Offset[{2, 2}, {2.16030845147679, -1.3046180834771546}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.2000061232341586`, -1.7324368727421864`}, 
          0.0278065427967146], 
         InsetBox["b", 
          Offset[{2, 2}, {1.2278126660308732, -1.7046303299454717}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.20000612323415856`, -1.7324368727421864`}, 
          0.0278065427967146], 
         InsetBox["c", 
          Offset[{2, 2}, {0.22781266603087316, -1.7046303299454717}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.2337564737583633`, -1.7324368727421864`}, 
          0.0278065427967146], 
         InsetBox["d", 
          Offset[{2, 2}, {2.261563016555078, -1.7046303299454717}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.1324941709203804`, -0.20000612323415856`}, 
          0.0278065427967146], 
         InsetBox["e", 
          Offset[{2, 2}, {2.160300713717095, -0.17219958043744396}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.266594600610184, -0.7662172269307757}, 
          0.0278065427967146], 
         InsetBox["f", 
          Offset[{2, 2}, {1.2944011434068987, -0.7384106841340611}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.20000612323415856`, -0.7662143496480989}, 
          0.0278065427967146], 
         InsetBox["g", 
          Offset[{2, 2}, {0.22781266603087316, -0.7384078068513843}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.8674945778142513`, -0.7662109312456952}, 
          0.0278065427967146], 
         InsetBox["h", 
          Offset[{2, 2}, {2.895301120610966, -0.7384043884489806}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.9670564671558237`*^9, 3.967056497398329*^9}, {
   3.967056538803359*^9, 3.967056569283257*^9}, 3.9670567401756973`*^9, {
   3.9670584552982397`*^9, 3.9670584759522753`*^9}, {3.967059249458517*^9, 
   3.967059264495891*^9}, 3.967105230628639*^9, {3.967105855712229*^9, 
   3.9671058792140627`*^9}, {3.967106505222485*^9, 3.967106557230167*^9}, {
   3.9671068248668337`*^9, 3.967106851363492*^9}, 3.9671093475374193`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"138bfc1b-ef62-439b-b683-416ef1dcd8ff"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.967109347554996*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"e65365d1-5f84-49ba-8e61-284d9fd14a70"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.9671093475555763`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"4a34e3a2-d2c6-4ecc-a886-ed3cb49a71d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.967109347556232*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"730ee066-02bf-4e10-a24e-387f94754e3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.967109347556609*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"5bdc4d32-751c-42df-8b53-07de2e34e32d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.967109347556973*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"54d83e20-4aa7-403a-8436-655eac01ec17"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.967109347613888*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"384c8397-62b3-49fe-a191-458532df7587"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.9671093486206293`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"abcdc23b-cffa-4104-9c2c-8d6fcb37ff8d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo2/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo2/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.9671093486241713`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"03e92615-72b7-4037-a7d3-7190b8424d37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo2\"\>"}],
  SequenceForm["Archivo: ", "grafo2"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.967109348626492*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"3d5d1e9e-cae9-4402-8080-4d4a4c8182b9"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.967109349098403*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"63b7a738-9a8a-4adf-845b-5a1d3554ba84"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo2/grafo2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo2/grafo2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967106505242141*^9, 3.9671065572536087`*^9}, {
   3.967106824886442*^9, 3.9671068513831244`*^9}, 3.967109349098962*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[19]:=",ExpressionUUID->"6a8e931c-64e3-4a44-a8ce-f36398d27ceb"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo2/grafo2.pdf\"\>\
"], "Output",
 CellChangeTimes->{{3.9670564671558237`*^9, 3.967056497398329*^9}, {
   3.967056538803359*^9, 3.967056569283257*^9}, 3.9670567401756973`*^9, {
   3.9670584552982397`*^9, 3.9670584759522753`*^9}, {3.967059249458517*^9, 
   3.967059264495891*^9}, 3.967105230628639*^9, {3.967105855712229*^9, 
   3.9671058792140627`*^9}, {3.967106505222485*^9, 3.967106557230167*^9}, {
   3.9671068248668337`*^9, 3.967106851363492*^9}, 3.967109349110203*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"e4cff76d-fc89-495d-bf2b-2abec351e652"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: grafo dirigido con opciones b\[AAcute]sicas", "Subsection",
 CellChangeTimes->{{3.967054930683444*^9, 3.967054955164653*^9}, {
  3.967057693612714*^9, 3.967057751770035*^9}, {3.967057879230571*^9, 
  3.967057908406308*^9}, {3.967058490984441*^9, 3.967058491986677*^9}, {
  3.967059626585574*^9, 3.9670596516816387`*^9}, {3.967106586432419*^9, 
  3.967106586834073*^9}},ExpressionUUID->"525ae2f7-fe79-4cd5-a91e-\
cb7342e83d33"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo3", "=", 
  RowBox[{"System`Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "->", "b"}], ",", 
      RowBox[{"b", "->", "c"}], ",", 
      RowBox[{"c", "->", "d"}], ",", 
      RowBox[{"d", "->", "a"}], ",", 
      RowBox[{"a", "->", "c"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "->", "\"\<Name\>\""}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo3", ",", "\"\<grafo3.tex\>\"", ",", 
    RowBox[{"\"\<Directed\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<EdgeThickness\>\"", "->", "\"\<very thick\>\""}], 
    RowBox[{"(*", "grosor", "*)"}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<gray\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<green\>\""}], ",", 
    RowBox[{"\"\<NodeShape\>\"", "->", "\"\<triangle\>\""}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967054959471537*^9, 3.967054972736125*^9}, {
   3.9670551896514797`*^9, 3.967055193625971*^9}, 3.967056199589128*^9, {
   3.967056651451857*^9, 3.967056658863533*^9}, {3.967056703913054*^9, 
   3.967056709609578*^9}, {3.967057768588723*^9, 3.967057867623065*^9}, {
   3.967058199493162*^9, 3.967058265313793*^9}, {3.9670583079518633`*^9, 
   3.967058308798773*^9}, {3.967058495576191*^9, 3.967058522170431*^9}, 
   3.967105140090682*^9, {3.967106606687722*^9, 3.9671067364392357`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"e825f494-0466-4101-9211-195fd581196b"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d}, \
{{{1, 2}, {2, 3}, {3, 4}, {4, 1}, {1, 3}}, Null}, {
      VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], 
        ArrowBox[{{{0.9326380450783072, 0.}, {1.8676596848949671`, 
         0.43506881348705806`}}, {{0.9326380450783072, 0.}, {
         0.9337949241686073, 0.8694369708962658}}, {{1.8676596848949671`, 
         0.43506881348705806`}, {0.9337949241686073, 0.8694369708962658}}, {{
         0.9337949241686073, 0.8694369708962658}, {0., 
         0.4356077734422885}}, {{0., 0.4356077734422885}, {0.9326380450783072,
          0.}}}, 0.021528537976677004`]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0.9326380450783072, 0.}, 0.021528537976677004], 
         InsetBox["a", 
          Offset[{2, 2}, {0.9541665830549841, 0.021528537976677004}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8676596848949671`, 0.43506881348705806`}, 
          0.021528537976677004], 
         InsetBox["b", 
          Offset[{2, 2}, {1.8891882228716441, 0.45659735146373504}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9337949241686073, 0.8694369708962658}, 
          0.021528537976677004], 
         InsetBox["c", 
          Offset[{2, 2}, {0.9553234621452843, 0.8909655088729428}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.4356077734422885}, 0.021528537976677004], 
         InsetBox["d", 
          Offset[{2, 2}, {0.021528537976677004, 0.4571363114189655}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.967056688480299*^9, 3.9670567617248487`*^9, {3.967057775824847*^9, 
   3.9670578698964863`*^9}, {3.967058191130074*^9, 3.96705826588723*^9}, 
   3.967058309211049*^9, {3.967058502859602*^9, 3.96705852259554*^9}, {
   3.967106596369959*^9, 3.967106629242201*^9}, {3.967106663407357*^9, 
   3.967106743982141*^9}, 3.967109364790971*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"73a6afc6-7e00-4943-b44f-7c709c5a3bad"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.967109364796596*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"e842ea69-92b6-4bff-b717-b998fadd499e"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.967109364797409*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"db428f00-f55f-4167-81dc-8aab16235533"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.967109364797999*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"2c9d6182-10ce-4d1a-b8d5-cc001bc0b0bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.967109364798379*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"4436347c-a882-40d3-9d02-32b02fc10698"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.96710936479875*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"afb27ae0-f3c1-44fd-99bb-e16681d23006"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.9671093648808517`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"2f48cced-6e7c-45cb-bafe-01cdaf5734e4"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.967109365886787*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"859ceac4-3aa9-4c67-afc6-e73e93f4ddd9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo3/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo3/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.96710936588976*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"cb6088ed-57e4-4bc4-a538-f74712462cf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo3\"\>"}],
  SequenceForm["Archivo: ", "grafo3"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.967109365891427*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"dfa234a2-9cf1-4c69-aea7-a175a6ef10d2"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.967109366350396*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"c22564bb-1c1b-4c03-808a-70392c780b33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo3/grafo3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo3/grafo3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967056688486526*^9, 3.9670567617504673`*^9, {3.967057775853415*^9, 
   3.967057869919001*^9}, {3.967058191151165*^9, 3.967058265911446*^9}, 
   3.9670583092175703`*^9, {3.967058502882552*^9, 3.967058522601942*^9}, {
   3.9671065963883142`*^9, 3.9671066292478952`*^9}, {3.967106663427153*^9, 
   3.967106743998698*^9}, 3.967109366350946*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[22]:=",ExpressionUUID->"12066274-47fb-4f16-b226-587ffa6ec8d8"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo3/grafo3.pdf\"\>\
"], "Output",
 CellChangeTimes->{
  3.967056688480299*^9, 3.9670567617248487`*^9, {3.967057775824847*^9, 
   3.9670578698964863`*^9}, {3.967058191130074*^9, 3.96705826588723*^9}, 
   3.967058309211049*^9, {3.967058502859602*^9, 3.96705852259554*^9}, {
   3.967106596369959*^9, 3.967106629242201*^9}, {3.967106663407357*^9, 
   3.967106743982141*^9}, 3.967109366362404*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"d240213e-17ae-4390-88a0-65dba34c377f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: grafo no dirigido con etiquetas personalizadas", "Subsection",
 CellChangeTimes->{{3.967055044401237*^9, 
  3.967055072196827*^9}},ExpressionUUID->"3a577e16-983e-4c54-a12d-\
c377f678a17d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo4", "=", 
  RowBox[{"System`Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "<->", "2"}], ",", 
      RowBox[{"2", "<->", "3"}], ",", 
      RowBox[{"3", "<->", "4"}], ",", 
      RowBox[{"4", "<->", "1"}], ",", 
      RowBox[{"1", "<->", "3"}]}], "}"}], ",", 
    RowBox[{"VertexLabels", "->", "\"\<Name\>\""}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo4", ",", "\"\<grafo4.tex\>\"", ",", 
    RowBox[{"\"\<Directed\>\"", "->", "False"}], ",", 
    RowBox[{"\"\<VertexLabelColor\>\"", "->", "\"\<white\>\""}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<black\>\""}], ",", 
    RowBox[{"\"\<NodeShape\>\"", "->", "\"\<square\>\""}], ",", 
    RowBox[{"\"\<VertexSize\>\"", "->", "0.4"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967055077225473*^9, 3.967055086135191*^9}, 
   3.967055185226714*^9, 3.9670562021523*^9, {3.967056788559585*^9, 
   3.967056818589801*^9}, {3.967056859006214*^9, 3.967056859468305*^9}, {
   3.96705737120119*^9, 3.9670574002758713`*^9}, 3.967058166959111*^9, 
   3.967058560979497*^9, 3.967105084052264*^9},
 CellLabel->"In[25]:=",ExpressionUUID->"fb3e59ad-1649-4a2b-945b-cafdf7c44403"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4}, {Null, {{1, 2}, {2, 3}, {3, 4}, {4, 1}, {1, 3}}}, {
      VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[0.], 
        ArrowBox[{{{0.932893845025013, 0.8689936409769883}, {0., 
         0.4347918739550035}}, {{0.932893845025013, 0.8689936409769883}, {
         0.9339391948842662, 0.}}, {{0.932893845025013, 0.8689936409769883}, {
         1.8680725328724752`, 0.43527779487072843`}}, {{0., 
         0.4347918739550035}, {0.9339391948842662, 0.}}, {{0.9339391948842662,
          0.}, {1.8680725328724752`, 0.43527779487072843`}}}, 
         0.02153194489703608]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.932893845025013, 0.8689936409769883}, 
          0.02153194489703608], 
         InsetBox["1", 
          Offset[{2, 2}, {0.9544257899220492, 0.8905255858740244}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.4347918739550035}, 0.02153194489703608], 
         InsetBox["2", 
          Offset[{2, 2}, {0.02153194489703608, 0.4563238188520396}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9339391948842662, 0.}, 0.02153194489703608], 
         InsetBox["3", 
          Offset[{2, 2}, {0.9554711397813023, 0.02153194489703608}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8680725328724752`, 0.43527779487072843`}, 
          0.02153194489703608], 
         InsetBox["4", 
          Offset[{2, 2}, {1.8896044777695113, 0.4568097397677645}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.967056848531086*^9, 3.967056859792282*^9}, {
   3.967057373041705*^9, 3.9670574007387667`*^9}, 3.9670581673306437`*^9, {
   3.9670585541512327`*^9, 3.9670585613687763`*^9}, 3.9671067839639063`*^9, 
   3.967109377555901*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"6ebd9206-f975-4423-a2ed-41f8ece472d8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.967109377573913*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"66c65e6a-8670-4ab4-b056-46810c2a7f20"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.967109377574443*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"0180b551-8d63-4c30-ad3e-61c009fd6a04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.9671093775750647`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"17b1d9b2-5f73-487c-bea6-eb5e582b3e7e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.967109377575429*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"128d3dc8-cf0d-49e2-a43f-5ccab62743c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.9671093775757923`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"b143d9ad-7e60-4531-80d8-c54d15967e86"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.967109377666478*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"8622eab0-d9f3-4a61-87cf-30d60ce6b664"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.9671093786726017`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"ae508162-0c84-422a-83e9-f0d0c696d211"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo4/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo4/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.967109378676079*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"30a6364c-346e-4993-b67c-821bce094ceb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo4\"\>"}],
  SequenceForm["Archivo: ", "grafo4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.967109378678658*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"24c0472f-8cde-448b-ba4b-aeaa0e6be9e1"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.96710937913864*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"fd46a76b-d454-446d-b1da-14327add3399"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo4/grafo4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo4/grafo4.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670568485383472`*^9, 3.967056859817954*^9}, {
   3.967057373071521*^9, 3.967057400758768*^9}, 3.9670581673366632`*^9, {
   3.967058554174258*^9, 3.9670585613882113`*^9}, 3.9671067839838057`*^9, 
   3.967109379139193*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[25]:=",ExpressionUUID->"a38f6b11-aaf7-4cae-b609-e58e0a957afe"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo4/grafo4.pdf\"\>\
"], "Output",
 CellChangeTimes->{{3.967056848531086*^9, 3.967056859792282*^9}, {
   3.967057373041705*^9, 3.9670574007387667`*^9}, 3.9670581673306437`*^9, {
   3.9670585541512327`*^9, 3.9670585613687763`*^9}, 3.9671067839639063`*^9, 
   3.967109379150714*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"a5ce1003-d68d-461b-9b58-5430062b3970"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 5: grafo ponderado", "Subsection",
 CellChangeTimes->{{3.9670550945923443`*^9, 3.9670551136411133`*^9}, {
  3.967057496127215*^9, 3.967057509053504*^9}, {3.9671068072404547`*^9, 
  3.967106808102374*^9}},ExpressionUUID->"addc83d4-5155-4af4-889b-\
c07e285411e1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo5", "=", 
  RowBox[{"System`Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "2"}], ",", 
      RowBox[{"2", "->", "3"}], ",", 
      RowBox[{"3", "->", "1"}]}], "}"}], ",", 
    RowBox[{"System`EdgeWeight", "->", 
     RowBox[{"{", 
      RowBox[{"5", ",", "8", ",", "3"}], "}"}]}], ",", 
    RowBox[{"VertexLabels", "->", "\"\<Name\>\""}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo5", ",", "\"\<grafo5.tex\>\"", ",", 
    RowBox[{"\"\<Directed\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<EdgeWeightColor\>\"", "->", "\"\<blue\>\""}], ",", 
    RowBox[{"\"\<EdgeWeightSize\>\"", "->", "\"\<Large\>\""}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<cyan\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<gray\>\""}], ",", 
    RowBox[{"\"\<NodoShape\>\"", "->", "\"\<square\>\""}], ",", 
    RowBox[{"\"\<VertexSize\>\"", "->", "0.25"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9670551171657887`*^9, 3.967055126531004*^9}, 
   3.9670551822851143`*^9, 3.967056205883909*^9, {3.9670568651046762`*^9, 
   3.9670568654821463`*^9}, {3.967056960219596*^9, 3.967056981121058*^9}, {
   3.967057036550911*^9, 3.967057068305481*^9}, {3.967057108663397*^9, 
   3.967057110068399*^9}, {3.9670571453956547`*^9, 3.967057213184716*^9}, {
   3.967057282192034*^9, 3.967057309784225*^9}, 3.967057571489881*^9, {
   3.9670585913541203`*^9, 3.967058597191285*^9}, 3.967105089859573*^9, {
   3.9671068849164953`*^9, 3.96710688546491*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"97ffcfd2-2152-45cc-9fe1-cd16d8503d69"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3}, {{{1, 2}, {2, 3}, {3, 1}}, Null}, {
      VertexLabels -> {"Name"}, EdgeWeight -> {5, 8, 3}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], 
        ArrowBox[{{{-0.8660254037844384, -0.4999999999999994}, {
         0.8660254037844389, -0.5000000000000012}}, {{
         0.8660254037844389, -0.5000000000000012}, {1.8369701987210297`*^-16, 
         1.}}, {{1.8369701987210297`*^-16, 
         1.}, {-0.8660254037844384, -0.4999999999999994}}}, 
         0.020399597244776385`]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{-0.8660254037844384, -0.4999999999999994}, 
          0.020399597244776385], 
         InsetBox["1", 
          Offset[{2, 2}, {-0.845625806539662, -0.479600402755223}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8660254037844389, -0.5000000000000012}, 
          0.020399597244776385], 
         InsetBox["2", 
          Offset[{2, 2}, {0.8864250010292153, -0.47960040275522486}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8369701987210297`*^-16, 1.}, 0.020399597244776385], 
         InsetBox["3", 
          Offset[{2, 2}, {0.02039959724477657, 1.0203995972447764}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.967057001329947*^9, 3.967057069174128*^9, {3.9670571558429947`*^9, 
   3.967057213972686*^9}, {3.967057283531765*^9, 3.967057310640634*^9}, 
   3.9670575737935*^9, {3.9670585761791143`*^9, 3.967058598523169*^9}, {
   3.967106928373238*^9, 3.967106943222209*^9}, 3.967109387786882*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"a5c4670e-6ca5-4bea-93e8-e9feb2525978"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109387806199*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"012771b9-fa1e-4df1-9c5d-eeaa804bc743"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.9671093878067083`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"b634da0a-7f8e-41b3-b77a-8f04f8c2079a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109387807295*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"a3cf1f71-2215-4b3a-a1b1-f2c9920f25d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109387807644*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"24a416bf-c471-458e-ba36-103ef3b9f899"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109387807996*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"54ccefc6-2b53-49e5-a722-c63b33430a2d"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109387884779*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"cf281fb0-bad5-49ca-bbbf-b6317484f531"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109388891346*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"cefa074f-2635-4d50-bf04-bc5899a69105"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo5/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo5/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109388894475*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"746c96b1-a933-4d36-893e-4de98426cd9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo5\"\>"}],
  SequenceForm["Archivo: ", "grafo5"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.9671093888964148`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"06f1ccf2-943a-4972-a5a4-e82c7e8c726d"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109389365395*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"a2d5595a-c3ad-496b-9496-28d7f607a2b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo5/grafo5.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo5/grafo5.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9670570013558817`*^9, 3.967057069207446*^9, {3.96705715587018*^9, 
   3.9670572140009413`*^9}, {3.967057283537099*^9, 3.967057310675015*^9}, 
   3.9670575738217373`*^9, {3.967058576185054*^9, 3.967058598555571*^9}, {
   3.967106928378858*^9, 3.9671069432271833`*^9}, 3.967109389365963*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[28]:=",ExpressionUUID->"79fe6cd7-b96f-4e30-b3e5-c02a810accaa"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo5/grafo5.pdf\"\>\
"], "Output",
 CellChangeTimes->{
  3.967057001329947*^9, 3.967057069174128*^9, {3.9670571558429947`*^9, 
   3.967057213972686*^9}, {3.967057283531765*^9, 3.967057310640634*^9}, 
   3.9670575737935*^9, {3.9670585761791143`*^9, 3.967058598523169*^9}, {
   3.967106928373238*^9, 3.967106943222209*^9}, 3.967109389377604*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"e9ebae8e-b6f2-4ba8-a5a4-e7385d89bbbe"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6: grafo con ejes y rejilla", "Subsection",
 CellChangeTimes->{{3.967055146839373*^9, 
  3.967055162829235*^9}},ExpressionUUID->"5466315c-7069-4a5e-ab14-\
830fe42ccbbe"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo6", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "g"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "j"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "j"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "j"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", "j"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "j"}], "}"}]}], "}"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo6", ",", "\"\<grafo6.tex\>\"", ",", 
    RowBox[{"\"\<ShowAxes\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<Grid\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<XMin\>\"", "->", 
     RowBox[{"-", "0.5"}]}], ",", 
    RowBox[{"\"\<XMax\>\"", "->", "4"}], ",", 
    RowBox[{"\"\<YMin\>\"", "->", 
     RowBox[{"-", "0.5"}]}], ",", 
    RowBox[{"\"\<YMax\>\"", "->", "3"}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<orange\>\""}], ",", 
    RowBox[{"\"\<EdgeThickness\>\"", "->", "\"\<ultra thick\>\""}], ",", 
    RowBox[{"\"\<VertexSize\>\"", "->", "0.4"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967055166265751*^9, 3.9670551790918903`*^9}, 
   3.967056208706801*^9, {3.967056870311821*^9, 3.967056870690933*^9}, {
   3.967058635550021*^9, 3.967058693166059*^9}, 3.96710509481098*^9, {
   3.9671069943771353`*^9, 3.9671069979160557`*^9}, {3.967107036991148*^9, 
   3.967107073026235*^9}, {3.9671071122399607`*^9, 3.967107149225564*^9}, {
   3.96710719375178*^9, 3.9671071949174213`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"fea70c67-5cbd-49be-9d49-a33247307087"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`f, $CellContext`g, $CellContext`j, \
$CellContext`b, $CellContext`e, $CellContext`i, $CellContext`c, \
$CellContext`d, $CellContext`h}, {
      Null, {{1, 2}, {1, 3}, {1, 4}, {5, 6}, {5, 7}, {8, 9}, {8, 6}, {8, 2}, {
       9, 6}, {9, 4}, {6, 2}, {6, 10}, {3, 4}, {10, 4}, {7, 4}}}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[0.], 
        ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGDgB2ImKE7qS2o7283icH3qry2n9n61X7jgumbU6n/2n3KP
cd3adtMeXb4shFtIw5TNYcer50wOXYwO6PIzlJb1cv37bc8x6edz1kf/MMxb
adXLUl720n4R34mT3fwvMeQXxN6tCZ342Z4BCtDtQzcfnT+9RHjXlztP7F2m
W+eqX2HGUL/0goJj26Nv9vmCYXPvvHuNob/h8M4ADe539vpcViVWE3/B3bHA
5vcG58e/MNyPLo9uP7p6dP+hy6O7D10e3X3o5qHrBwADnuOQ
         "], 0.02861098434786176]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.568263101465889, 1.358835894535664}, 0.02861098434786176],
          InsetBox["a", 
          Offset[{2, 2}, {2.596874085813751, 1.3874468788835257}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.9168340334381713`, 0.4017853837228521}, 
          0.02861098434786176], 
         InsetBox["f", 
          Offset[{2, 2}, {1.945445017786033, 0.43039636807071385}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.7759553346355075`, 2.1925049044633305`}, 
          0.02861098434786176], 
         InsetBox["g", 
          Offset[{2, 2}, {2.8045663189833694, 2.2211158888111924}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.7495217831766805`, 1.9301814137953688`}, 
          0.02861098434786176], 
         InsetBox["j", 
          Offset[{2, 2}, {1.7781327675245422, 1.9587923981432305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.6804844773612686`}, 0.02861098434786176], 
         InsetBox["b", 
          Offset[{2, 2}, {0.02861098434786176, 1.7090954617091303}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.795711048974984, 0.7831477108997726}, 
          0.02861098434786176], 
         InsetBox["e", 
          Offset[{2, 2}, {0.8243220333228458, 0.8117586952476344}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6519721636101562, 2.4785908254442877`}, 
          0.02861098434786176], 
         InsetBox["i", 
          Offset[{2, 2}, {0.680583147958018, 2.5072018097921496}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.2229819180991868`, 0.}, 0.02861098434786176], 
         InsetBox["c", 
          Offset[{2, 2}, {1.2515929024470485, 0.02861098434786176}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.4303038162297892`, 0.872907931611321}, 
          0.02861098434786176], 
         InsetBox["d", 
          Offset[{2, 2}, {1.4589148005776509, 0.9015189159591828}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9388619972870487, 1.6604561367136161`}, 
          0.02861098434786176], 
         InsetBox["h", 
          Offset[{2, 2}, {0.9674729816349105, 1.6890671210614778}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.967058617269834*^9, 3.9670586941292973`*^9}, {
   3.967107016295236*^9, 3.967107073470497*^9}, {3.967107113312983*^9, 
   3.9671071501103373`*^9}, 3.967107195856579*^9, 3.967109416066331*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"f2158e23-1b6a-439e-9b97-cd513edb49f2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.9671094160903683`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"ec1ff163-a8fd-4172-863a-30641ac13831"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.967109416090893*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"5bd824a8-6052-419e-8634-39503553c079"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.967109416091468*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"c207ba6d-8394-40a8-8047-1a2f3f09c042"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.9671094160918007`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"56cfdac2-8e95-47fc-adea-2893a03678f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.967109416092125*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"024ccf24-231d-4f9f-9737-48856758ae5f"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.9671094161826897`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"7be3f2e9-8ba5-4909-9186-ff3a0ff9cac6"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.967109417186161*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"2821b78b-1ca3-4df8-b72d-e8aaa158ad4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo6/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo6/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.967109417188696*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"437a05bd-2f22-4d07-94a7-e66f2b518784"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo6\"\>"}],
  SequenceForm["Archivo: ", "grafo6"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.96710941719035*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"90e799c9-7f9d-44b7-b52e-13ef36828493"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.967109417855331*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"654a8542-5b1d-46a4-8bbd-55230bd53c66"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo6/grafo6.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo6/grafo6.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.96705861729452*^9, 3.9670586941483307`*^9}, {
   3.9671070163197613`*^9, 3.9671070734963827`*^9}, {3.967107113334807*^9, 
   3.967107150117805*^9}, 3.967107195878426*^9, 3.967109417855904*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[31]:=",ExpressionUUID->"f2c34f25-60ad-471f-82f1-b660b1e7196b"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo6/grafo6.pdf\"\>\
"], "Output",
 CellChangeTimes->{{3.967058617269834*^9, 3.9670586941292973`*^9}, {
   3.967107016295236*^9, 3.967107073470497*^9}, {3.967107113312983*^9, 
   3.9671071501103373`*^9}, 3.967107195856579*^9, 3.967109417869178*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"8fa4b208-a9a1-4d50-9c36-0440330e9956"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 7: grafo con formas de nodos diferentes", "Subsection",
 CellChangeTimes->{{3.967055278002322*^9, 
  3.967055296046434*^9}},ExpressionUUID->"da9ff9c7-2ac2-4f6d-87a4-\
dfe973662d52"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo7", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"8", ",", "9"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"9", ",", "10"}], "}"}]}], "}"}], ",", 
    RowBox[{"vertices", "->", 
     RowBox[{"{", "1", "}"}]}], ",", 
    RowBox[{"dirigido", "->", "True"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo7", ",", "\"\<grafo7.tex\>\"", ",", 
    RowBox[{"\"\<Directed\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<NodeShape\>\"", "->", "\"\<triangle\>\""}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<yellow\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<purple\>\""}], ",", 
    RowBox[{"\"\<EdgeThickness\>\"", "->", "\"\<ultra thick\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9670553121403027`*^9, 3.967055312505273*^9}, 
   3.967055359215425*^9, 3.967056212122723*^9, {3.967056873882202*^9, 
   3.967056874243484*^9}, {3.967058708690817*^9, 3.967058743809101*^9}, 
   3.967105097939499*^9, {3.967107270511096*^9, 3.967107312193022*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"7735a67e-232a-4ed9-a67f-9ae4e9463180"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 4, 7, 8, 3, 6, 10, 5, 
      9}, {{{2, 3}, {2, 4}, {2, 5}, {6, 7}, {6, 8}, {3, 7}, {3, 4}, {3, 8}, {
       9, 7}, {9, 4}, {9, 5}, {9, 10}, {4, 10}, {5, 10}, {10, 8}}, Null}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], 
        ArrowBox[{{1.56251, -0.5625099999999996}, {
         3.56251, -1.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQXXQkqoaL4af9g46tP0QYHu0vhPL7vYMepjY83g+T
l04LkNDWfLq/GMpvvbF+bsqvZ3D+qUUFhUJfXsDVvz0yabKJ2Gs4/5WdGMvp
hLdw/jGB34euXn4P59vPVchYZf4RzueM+yK6ZOYnuHtOlSRc38X6BS7f031m
xsXCr3D7/RZZRL24+w3O59+5RPq/5w+4+gvnBe6KbvsJ5096VjNPR+k3nB/y
90W8c98fOF9UJFQx6tdfOP+a1sFHBWn/4e45X+rlYZrCcAAmb8cwh1uUm/EA
zP6tJqG7ry9H8E2Fy8JrrZjg6vfO/nef9TCC73fuXUihIzOc/3KV27b9WxH8
HkM2lo/yLHC+RZKuHWsDywEAn+LV4g==
          "]], 0.0437584130056701], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQXXQkqoaL4af9g46tP0QYHu1n5dmY9NXyh/3Onxw6
9j2P9zf8lL9+Jvi7/WE5becJEU/3P+lZfnOC7zf7/9+l7ThSn+/XPeae5aj+
1T6r9bbM8o0v98cvZei89+CzPfvxzPs5dm/2V2pdMs2o+mR/ac+x1kju9/ur
QvcU3Pv8wT7D+Ge7Gc/H/Sd86oqbZr2zr0/6tu/ypk/7M622KiryvrZf9/pW
ekvll/09X+MfX1V7ac9lZab3pOHrflGWhDUHKp/bTzTzsJed8m0/S9rWmoes
z+ydHgrM1t/8fX+YdEKIxekn9jJWExyl7/3Yz6eSYHz05GN7BcdjRg9Efu3X
adgq2cH42N7/26a8uvDf+9frJ7A3Fj2yXxEZ9vXr0j/7pxsl/Fkv88heK3vD
MTeGf/ufQMLF/prWwUcFaf/h/POlXh6mKQwHYHw7hjncotyMB55C+VtNQndf
X84IlzcVLguvtWKC8/fO/nef9TCC73fuXUihIzOc/3KV27b9WxH8HkM2lo/y
LHC+RZKuHWsDywEAy5zm7A==
          "]], 0.0437584130056701], 
        ArrowBox[{{3.56251, -1.5625099999999996`}, {
         1.56251, -2.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[{{3.56251, -1.5625099999999996`}, {
         3.56251, -2.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQbZmka8fawONQcCSqhovh5/48O6bT/I95HO7UsEyT
P/Zz/8bjpwRUwngdkvqnKnqs+bWf8V8bv9NNXgeGP7zyLZt+749+aHY8M4fP
Yeuh3L7LN/7sP1R4y3w2P79Dy+Mt+Wby//abri9MvHaI3yEz7vGhNa3/99/y
+beQ11nAYcvMP87SbQwHFszY+37LGgEHB8Pq+5mRjAde7/ommSgn6HC99K3x
IRumA23JBxu1ogUdWGSlxYsOMB3YlrhQ4+wEQQcP6SXz+byYD1RuncbnuV/Q
YVFBx9npN5kPnItbaDzvmaADn+yJBbz5LAe2xx6cfoZNyGGCQrJkARfrAeNN
36yuyAs5aFRHmu9fzXrAOcZRdquhkMMVndW/fgWxHXgWvdAu30bIYappRLIy
A/sBmY1i85kchBxY9X9xXfLhhPNTrDZk32XiOiAL5R9zTTvzYgeCrx4oo/sl
jxuuvj3mUu9/FR44/0V6xzuu2wi+Z7Gdv9hEXjh/Vd2X9YrufHA+d9cqAd2/
CH721IRCi838cP5zK9UlUkYCcPvlGc61drUi+NGzVt19fVkArn4W5+7VdrKC
cP593//vmxIRfI308lU7FiD4paHKt+/fQvCPSTA3/eAXgvOh9AEApb3urQ==

          "]], 0.0437584130056701], 
        ArrowBox[{{1.56251, -2.5625099999999996`}, {
         1.56251, -3.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[{{0.5625100000000001, -2.5625099999999996`}, {
         1.56251, -3.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[{{5.56251, -1.5625099999999996`}, {
         3.56251, -2.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQLbNRbD6Tg5hDwZGoGi6Gn/ulofzjqis/GB34uR8m
z2es0TN1yq/9slC+85vrfka1v+HyqYE7LDir/sD55UknPaW6/8L5ZfLcTakb
/sH5KR21D1+9/A/nL/ATMLk6m+EAjM+q/4vrkg/jAZh7Uq02ZN9lYoLLH3NN
O/NiB9MBmHs0AmV0v+Qxw+U7Yi71/ldhgfNfpHe847qN4HsV2/mLTWSF81fV
fVmv6M4G53N1rRLQ/cuG5h7OA0+jF9rl24g53Opjknz+n/OAU4yj7FZDMYc5
09c38q/lOmCy6ZvVFXkxB09PRlfvEO4D22IPTj/DJubwYPH3pFlfuQ+ci1to
PO+ZqEPS8km3/0zgOVCxdRqf535Rh/PBl9YVqfEe2Ja4UOPsBFEHjZXb7vze
ynugPflgo1a0qEPOcvvUGfZ8B17v+iaZKCfqMNMv18PjMN+B+TP2vt+yRsTB
YPL9OQuW8R+45fNvIa+ziEOcqP6c7zYCB2Zf32GQ/VDYYV5XCe+seQIHHli8
nX22XdghXNNhkfkPgQPrCmY/NjETduj+ODHqgqfgAcb6w+wL3wg5WDzONEuZ
LHjgZnIqh9BqIYeEf8dNP18RPGAh3/i0vVDIgdF5TUQtnxA0fIQcoPQBAIfL
9RQ=
          "]], 0.0437584130056701], 
        ArrowBox[{{2.56251, -1.5625099999999996`}, {
         1.56251, -2.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[{{2.56251, -1.5625099999999996`}, {
         0.5625100000000001, -2.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[{{2.56251, -1.5625099999999996`}, {
         3.56251, -2.5625099999999996`}}, 0.0437584130056701], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQbZmka8fawOJQcCSqhovh534LKP+46soPRgd+7ofJ
8xlr9Eyd8mu/FZTv/Oa6n1Htb7h8auAOC86qP3B+edJJT6nuv3B+mTx3U+qG
f3B+Skftw1cv/8P5C/wETK7OZjgA47Pq/+K65MN44PR2p9p7FSwOt/uYJJ//
ZzzQvqPJKiuZxWHO9PWN/GuZDmSkvC1dYc/i4OnJ6Oodwnwgf3eT/kxeFocH
i78nzfrKfGDuXqd0m7PMDknLJ93+M4HlwKcsXdlJdcwOF4IvrStSYz2Qe9gp
cJYis4P6ym13fm9lPcB/vIk5dBuTQ/Zy+9QZ9mwHbpS+NT5kw+Qw0y/Xw+Mw
2wEHw+r7mZGMDgaT789ZsIz9wNaZf5yl2xgc9mjFWbyv5DiQG/f40JrW//Y2
oi+lTGw5D7Q+3pJvJv/Pfl1Qg0v+B84D2w/l9l2+8cde9LHy1gWTuQ4w/eGV
b9n0277g2OWcE2rcB1L6pyp6rPllv/9Pf/azldwH7tewTJM/9tOeqS1i4y8Z
ngNFkHiyh8QTzwEAzGTCwQ==
          "]], 0.0437584130056701], 
        ArrowBox[{{1.56251, -3.5625099999999996`}, {4.56251, -4.56251}}, 
         0.0437584130056701]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0.56251, -5.687529999999999}, 0.0437584130056701], 
         InsetBox["1", Offset[{2, 2}, {0.60626841300567, -5.643771586994329}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.56251, -0.5625099999999996}, 0.0437584130056701], 
         InsetBox["2", 
          Offset[{2, 2}, {1.6062684130056701, -0.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.56251, -1.5625099999999996`}, 0.0437584130056701], 
         InsetBox["4", 
          Offset[{2, 2}, {3.60626841300567, -1.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.56251, -2.5625099999999996`}, 0.0437584130056701], 
         InsetBox["7", 
          Offset[{2, 2}, {1.6062684130056701, -2.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.5625100000000001, -2.5625099999999996`}, 
          0.0437584130056701], 
         InsetBox["8", 
          Offset[{2, 2}, {0.6062684130056701, -2.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.56251, -1.5625099999999996`}, 0.0437584130056701], 
         InsetBox["3", 
          Offset[{2, 2}, {5.60626841300567, -1.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.56251, -2.5625099999999996`}, 0.0437584130056701], 
         InsetBox["6", 
          Offset[{2, 2}, {3.60626841300567, -2.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.56251, -4.56251}, 0.0437584130056701], 
         InsetBox["10", 
          Offset[{2, 2}, {4.60626841300567, -4.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.56251, -1.5625099999999996`}, 0.0437584130056701], 
         InsetBox["5", 
          Offset[{2, 2}, {2.60626841300567, -1.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.56251, -3.5625099999999996`}, 0.0437584130056701], 
         InsetBox["9", 
          Offset[{2, 2}, {1.6062684130056701, -3.5187515869943295}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.96705871040443*^9, 3.967058744246091*^9}, 
   3.9671073200811357`*^9, 3.967109430149685*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"bb7aa20c-693b-4bad-8988-67b4765c2e9a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109430177412*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"0a7dec8d-ebd8-4b9f-b1cb-45d57cc3c199"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109430177919*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"e598dd65-2e85-4bd4-b3e3-49ea8c5f6cd6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.9671094301784697`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"fbe5425f-d5b0-4a9b-af46-f4abd14f1f61"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109430178804*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"9d57c086-ac7a-4bd6-bf11-426f715a6996"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109430179126*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"3901128a-e4ae-4d08-b1f0-64f6321bfed7"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109430261355*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"c195de48-c48e-4d3b-9a92-edce1e0a6c8e"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109431267365*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"3ecaf290-d8cd-43d7-ac10-3470352c9cd0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo7/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo7/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109431270838*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"b51b9ddf-83da-43e4-a679-4ee928006d6f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo7\"\>"}],
  SequenceForm["Archivo: ", "grafo7"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109431273073*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"bec962e4-c8f8-46b0-bfbc-6d255b5132cd"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.9671094317658243`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"2c440218-c296-4ca0-b702-6f38bf099113"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo7/grafo7.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo7/grafo7.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058710427981*^9, 3.967058744265594*^9}, 
   3.967107320108156*^9, 3.967109431766396*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[34]:=",ExpressionUUID->"7f13a566-6622-48d8-ae75-22d24f9c7da2"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo7/grafo7.pdf\"\>\
"], "Output",
 CellChangeTimes->{{3.96705871040443*^9, 3.967058744246091*^9}, 
   3.9671073200811357`*^9, 3.9671094317784567`*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"5bdf71e5-668e-4fc0-b802-929cb546ff5a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 8: grafos con estilos de l\[IAcute]nea", "Subsection",
 CellChangeTimes->{{3.9670553250577517`*^9, 
  3.967055343118499*^9}},ExpressionUUID->"8ee55263-5dd4-49cf-ae54-\
4f475395cc43"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo8", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "e"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "f"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "i"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"c", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"e", ",", "g"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"f", ",", "h"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"h", ",", "i"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "j"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "j"}], "}"}]}], "}"}], ",", 
    RowBox[{"dirigido", "->", "True"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo8", ",", "\"\<grafo8.tex\>\"", ",", 
    RowBox[{"\"\<NodeShape\>\"", "->", "\"\<triangle\>\""}], ",", 
    RowBox[{"\"\<EdgeStyle\>\"", "->", "\"\<dotted\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<blue\>\""}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<green\>\""}]}], "]"}], ";"}], "\n", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.967056215724916*^9, 3.967058767132167*^9, 3.967105101708639*^9, {
   3.967107369559873*^9, 3.967107448850936*^9}, {3.967107577375709*^9, 
   3.967107585161088*^9}, {3.96710762935949*^9, 3.96710765162934*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"ca3cf79c-b7ca-4bad-9ce1-560cea9496a4"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`f, $CellContext`g, $CellContext`a, $CellContext`d, \
$CellContext`e, $CellContext`h, $CellContext`b, $CellContext`c, \
$CellContext`i, $CellContext`j}, {{{1, 2}, {3, 4}, {3, 5}, {3, 6}, {7, 8}, {7,
        1}, {7, 9}, {8, 4}, {8, 6}, {4, 2}, {5, 2}, {1, 6}, {6, 9}, {9, 10}, {
       4, 10}}, Null}, {ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQo4HGbympsuPrRi/0ll7eKvc9gd5NavCb51eNf+
9llJug812R2q98wUPTv56H7LlGV6h5exOah/mj7B49i5/XcbvpXNFmZz8KnJ
OLu+5sr+8g9BbFkFrA5P05WkOsVu7WfZvPuO3l4Wh/d3bcQjJB7sbzlh8Ovl
T2YHWRvz1kmpj/f/NNgUN1uN2aHaj+H650/P9ie+sedydmZyCJ8cKmp/88V+
Y1ch9cn7GR0utIT6hLS92v/BrXPeN1NGh0dKDDXGv17vn/FxSUHuMgaH/tzQ
JXdM3u7Xck2d+12AweFaSuhRf7N3+wOap3hqvf5nv5OD4X7Pv3f7Fc8t5+1Z
8dfeLDL04+Te9/tPZrG0i0T9sfcLC/2T8vj9fvfIVVsP//9lDwmXD/tnzQSB
n3D++RtHX883/wHnfzmslPrg5Td7RiifLXoDa/SGr3B59nl5Z/m7v8D5X3ti
9/yr/AznX1avvaRe+wnOByuf8hHOj0j0K9E48AHOh9L2APE7wxE=
          "]], 0.03700564971751412], 
        ArrowBox[{{0., 3.}, {1., 2.}}, 0.03700564971751412], 
        ArrowBox[{{-1., 3.}, {0., 2.}}, 0.03700564971751412], 
        ArrowBox[{{-1., 3.}, {-2., 2.}}, 0.03700564971751412], 
        ArrowBox[{{-1., 3.}, {1., 2.}}, 0.03700564971751412], 
        ArrowBox[{{0., 2.}, {-1., 1.}}, 0.03700564971751412], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQjQYcYIzl8zZ2X7f/bw/jJ000+lCS/Q/O17vRpHuj
6S+cz128yJmx7Q+c/zMRpOE3nP9riT8Iwfk8NndnyYv9hPMN1a1EEk58h/PT
wOCb/cJNK1cxz86x37ks1MuG4SuU32NvPvV3xeuln+2rSv7zG4kvsH9gGPGp
OPwTVH6N/Yaa7G1XRT7a908OuSsVuc0+4nVWl+Ke91D1B+wXW+bYeqW9tT/y
ZuW5dc+O2js+udWqqvEaqv+MvenrbcmbGV/acyX/D5SQumRf7cdw/fOnZ/bH
2id+vWVy017Gxrx1Uupje0WXtov+5+/bv79rIx4h8cCe78y7ot1fHtk/S1eS
6hS7ZX/roLfkioNP7X1qMs6ur7liX8Z863au3wt79U/TJ3gcO2f/aMLMXTyz
X9lX75kpenbyUXuZrK6tLcvf2MutXxN86/Aue/X+NWeuFr+zn8trbrr40Apo
+HyAhxMA6Say1Q==
          "]], 0.03700564971751412], 
        ArrowBox[{{-2., 2.}, {-1., 1.}}, 0.03700564971751412], 
        ArrowBox[{{1., 2.}, {1., 1.}}, 0.03700564971751412], 
        ArrowBox[{{1., 4.}, {0., 3.}}, 0.03700564971751412], 
        ArrowBox[{{1., 4.}, {1., 3.}}, 0.03700564971751412], 
        ArrowBox[BezierCurveBox[CompressedData["
1:eJxTTMoPSmViYGBQBWIQDQEf7CG0gEPOjpWSosc+2J9Q1i7+Ooff4dMpq6W2
az7at89K0n2oye8wwXzzospNn+wtU5bpHV7G5+D6T0jo5I3P9ncbvpXNFuZz
EJaP+qwt/9W+7EMQW1YBr8PPmR1ui1q/2bNs3n1Hby+Pw4+8edw6PD/sm08Y
/Hr5k9uBf95sp5Obftr/NNgUN1uN28FOveF1ZeVv+8Q39lzOzlwOa06u6pqf
88feyFVIffJ+Tof0Q1pqWs5/7d+7dc77ZsrpUCTIsE/y71/7GR+XFOQu43A4
sU0rKG/WP3st19S53wU4HLI3rXqkLv3ffoXjKZWppewOsSwN+W71/+0Fnl9m
c7vC5jB7zaofJ4/9t08xbXLm0mVzUF+tVbfp43/7xTpXbz2sZ3WABpCDMRgw
w+VjLmupyjUwOcyB6p9zqnbP10uMDnFQ8z9I6Pzcqc0Itz9in+ntrC4Gh+NQ
960pNT0qcO+/fSHU/Zdktsmpbv5nnwH1n2LR20NCU/7aw/w/u/T2xpsNf+xh
4QOj+aDhB6Nh4Qujf0HDH0bD4gdGw+IPRvdD4xdGw+IfRudC0weMRk0/H+wB
kaUPCQ==
          "]], 0.03700564971751412], 
        ArrowBox[{{1., 3.}, {0., 2.}}, 0.03700564971751412], 
        ArrowBox[{{1., 3.}, {1., 2.}}, 0.03700564971751412], 
        ArrowBox[{{1., 1.}, {1., 0.}}, 0.03700564971751412]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 3.}, 0.03700564971751412], 
         InsetBox["f", 
          Offset[{2, 2}, {0.03700564971751412, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 1.}, 0.03700564971751412], 
         InsetBox["g", 
          Offset[{2, 2}, {-0.9629943502824859, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-1., 3.}, 0.03700564971751412], 
         InsetBox["a", 
          Offset[{2, 2}, {-0.9629943502824859, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 2.}, 0.03700564971751412], 
         InsetBox["d", 
          Offset[{2, 2}, {0.03700564971751412, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{-2., 2.}, 0.03700564971751412], 
         InsetBox["e", 
          Offset[{2, 2}, {-1.9629943502824858, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 2.}, 0.03700564971751412], 
         InsetBox["h", 
          Offset[{2, 2}, {1.0370056497175142, 2.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 4.}, 0.03700564971751412], 
         InsetBox["b", 
          Offset[{2, 2}, {1.0370056497175142, 4.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 3.}, 0.03700564971751412], 
         InsetBox["c", 
          Offset[{2, 2}, {1.0370056497175142, 3.037005649717514}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 1.}, 0.03700564971751412], 
         InsetBox["i", 
          Offset[{2, 2}, {1.0370056497175142, 1.0370056497175142}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{1., 0.}, 0.03700564971751412], 
         InsetBox["j", 
          Offset[{2, 2}, {1.0370056497175142, 0.03700564971751412}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.9670587675203037`*^9, {3.967107437457467*^9, 3.967107449544846*^9}, 
   3.9671075878393297`*^9, {3.967107633947324*^9, 3.96710768174326*^9}, 
   3.967109450659511*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"c5ce72d9-7daa-4385-b909-72242c11d0af"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.96710945068106*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"4b51449b-8726-409e-bac5-dccf4d0140b4"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.967109450681566*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"9cb278d6-ca0f-4f20-a753-946e3c652136"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.9671094506821537`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"c6b18a62-5bd6-44b6-a0f5-100d29499fcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.9671094506824913`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"59734f79-cb08-4307-b73c-d389327e90a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.967109450682825*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"8cf84d26-68b6-42fe-81f3-37aeef52fb21"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.967109450774276*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"ab0fef4c-2643-4430-81f1-44c0401bbf6c"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.967109451780387*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"26c668ea-75b4-4301-821b-4ff283d63412"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo8/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo8/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.967109451783679*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"bd71d9b1-e847-41a6-b8db-2635cfaf1c36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo8\"\>"}],
  SequenceForm["Archivo: ", "grafo8"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.9671094517857933`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"aa73ac03-9e36-497c-b345-8eabdb0ea8c1"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.967109452283104*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"88f1dfb0-dfb6-437f-a076-bfb184b9c7b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo8/grafo8.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo8/grafo8.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967058767546217*^9, {3.96710743746456*^9, 3.967107449566792*^9}, 
   3.967107587845962*^9, {3.967107633975059*^9, 3.967107681764742*^9}, 
   3.9671094522836733`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[37]:=",ExpressionUUID->"5f23e130-9c43-46ed-a745-878bb45077cf"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo8/grafo8.pdf\"\>\
"], "Output",
 CellChangeTimes->{
  3.9670587675203037`*^9, {3.967107437457467*^9, 3.967107449544846*^9}, 
   3.9671075878393297`*^9, {3.967107633947324*^9, 3.96710768174326*^9}, 
   3.967109452295354*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"f15d31dd-c348-4cb9-a546-a8c6ca2ba80b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 9: con todas las opciones", "Subsection",
 CellChangeTimes->{{3.9670553817304077`*^9, 
  3.96705539618997*^9}},ExpressionUUID->"6e84a932-cc10-41ba-89b6-\
cfdc96bb86aa"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo9", "=", 
  RowBox[{"System`Graph", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"DirectedEdge", "[", 
       RowBox[{"A", ",", "B"}], "]"}], ",", 
      RowBox[{"DirectedEdge", "[", 
       RowBox[{"B", ",", "C"}], "]"}], ",", 
      RowBox[{"DirectedEdge", "[", 
       RowBox[{"C", ",", "D"}], "]"}], ",", 
      RowBox[{"DirectedEdge", "[", 
       RowBox[{"D", ",", "A"}], "]"}], ",", 
      RowBox[{"DirectedEdge", "[", 
       RowBox[{"A", ",", "C"}], "]"}], ",", 
      RowBox[{"DirectedEdge", "[", 
       RowBox[{"B", ",", "D"}], "]"}]}], "}"}], ",", 
    RowBox[{"System`EdgeWeight", "->", 
     RowBox[{"{", 
      RowBox[{
      "2.5", ",", "1.8", ",", "3.2", ",", "0.9", ",", "4.1", ",", "2.7"}], 
      "}"}]}], ",", 
    RowBox[{"VertexLabels", "->", "\"\<Name\>\""}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo9", ",", "\"\<grafo9.tex\>\"", ",", 
    RowBox[{"\"\<Directed\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<VertexSize\>\"", "->", "0.35"}], ",", 
    RowBox[{"\"\<EdgeThickness\>\"", "->", "\"\<ultra thick\>\""}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<cyan\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<magenta\>\""}], ",", 
    RowBox[{"\"\<VertexLabels\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<VertexLabelColor\>\"", "->", "\"\<green\>\""}], ",", 
    RowBox[{"\"\<NodeShape\>\"", "->", "\"\<square\>\""}], ",", 
    RowBox[{"\"\<EdgeStyle\>\"", "->", "\"\<dashed\>\""}], ",", 
    RowBox[{"\"\<ShowEdgeWeights\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<EdgeWeightColor\>\"", "->", "\"\<red\>\""}], ",", 
    RowBox[{"\"\<EdgeWeightSize\>\"", "->", "\"\<small\>\""}], ",", 
    RowBox[{"\"\<Grid\>\"", "->", "False"}], ",", 
    RowBox[{"\"\<ShowAxes\>\"", "->", "False"}], ",", 
    RowBox[{"\"\<XMin\>\"", "->", "Automatic"}], ",", 
    RowBox[{"\"\<XMax\>\"", "->", "Automatic"}], ",", 
    RowBox[{"\"\<YMin\>\"", "->", "Automatic"}], ",", 
    RowBox[{"\"\<YMax\>\"", "->", "Automatic"}], ",", 
    RowBox[{"\"\<GraphScale\>\"", "->", "2.5"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967055422339149*^9, 3.967055495424921*^9}, 
   3.9670562212594223`*^9, {3.9670568804404*^9, 3.967056880785798*^9}, {
   3.967058807340685*^9, 3.967058883662826*^9}, 3.9671051066296473`*^9, {
   3.967107863467985*^9, 3.967107897840415*^9}, {3.9671079407792177`*^9, 
   3.967107975591073*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"3b8a0015-13ed-4218-9947-0c0b685cc52f"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`A, $CellContext`B, C, D}, {{{1, 2}, {2, 3}, {3, 4}, {
       4, 1}, {1, 3}, {2, 4}}, Null}, {
      VertexLabels -> {"Name"}, 
       EdgeWeight -> {2.5, 1.8, 3.2, 0.9, 4.1, 2.7}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[
        Medium], 
        ArrowBox[{{{0., 0.005788273178774839}, {0.005449076605152092, 
         0.8716212660229963}}, {{0., 0.005788273178774839}, {
         0.8665633651865193, 0.}}, {{0.005449076605152092, 
         0.8716212660229963}, {0.8665633651865193, 0.}}, {{
         0.005449076605152092, 0.8716212660229963}, {0.8713646272358624, 
         0.8657196778661429}}, {{0.8665633651865193, 0.}, {0.8713646272358624,
          0.8657196778661429}}, {{0.8713646272358624, 0.8657196778661429}, {
         0., 0.005788273178774839}}}, 0.011095738716472743`]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 0.005788273178774839}, 0.011095738716472743], 
         InsetBox["A", 
          Offset[{2, 2}, {0.011095738716472743, 0.016884011895247582}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.005449076605152092, 0.8716212660229963}, 
          0.011095738716472743], 
         InsetBox["B", 
          Offset[{2, 2}, {0.016544815321624835, 0.882717004739469}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8665633651865193, 0.}, 0.011095738716472743], 
         InsetBox["C", 
          Offset[{2, 2}, {0.8776591039029921, 0.011095738716472743}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8713646272358624, 0.8657196778661429}, 
          0.011095738716472743], 
         InsetBox["D", 
          Offset[{2, 2}, {0.8824603659523351, 0.8768154165826156}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{{3.9670588077513742`*^9, 3.967058884483733*^9}, 
   3.967107915436002*^9, 3.9671080052797813`*^9, 3.967109461658802*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"340ac076-ba55-4aae-81d6-853c65d91893"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.967109461664894*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"b3f5eafa-5a72-4350-a691-2a52e0de9e32"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.967109461665681*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"9b27015b-5d49-49c1-905d-4cb32d401634"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.9671094616662416`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"f1e457d7-e617-41ae-b69a-08997b90be27"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.9671094616665993`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"962c25f5-1ec8-4f98-bef5-cc681f408b29"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.967109461666953*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"e592d44b-6201-444e-9382-ba5eb037f2f1"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.967109461762478*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"39f2c9da-1039-4946-b441-a76a8c4c500b"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.9671094627683*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"856679fc-7441-4464-9fe4-645ec00b9be0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"/Users/enriquevilchezquesada/Downloads/grafo9/\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/grafo9/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.9671094627708893`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"a0c228d6-3f63-4b5b-934b-a09e67d476bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo9\"\>"}],
  SequenceForm["Archivo: ", "grafo9"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.967109462772379*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"967f4d58-7a8c-40ef-be4a-9506e5bd0448"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.967109463252988*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"37d7dc27-15e4-4eb1-9f29-bbe53ad4bfe7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo9/grafo9.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo9/grafo9.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967058807759089*^9, 3.96705888449021*^9}, 
   3.9671079154416656`*^9, 3.967108005307548*^9, 3.967109463253557*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[40]:=",ExpressionUUID->"5e3600e1-abb5-48ef-b889-3b1771afc0c5"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo9/grafo9.pdf\"\>\
"], "Output",
 CellChangeTimes->{{3.9670588077513742`*^9, 3.967058884483733*^9}, 
   3.967107915436002*^9, 3.9671080052797813`*^9, 3.967109463265686*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"f3c1a61d-5235-4689-8159-25cf3006967b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 10: otro grafo aleatorio", "Subsection",
 CellChangeTimes->{{3.967055502091723*^9, 3.967055514105565*^9}, {
  3.967059092771044*^9, 
  3.967059098424101*^9}},ExpressionUUID->"67d8266d-ccbb-4e6e-99a0-\
3bd14c3ad595"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo10", "=", 
  RowBox[{"GrafoRandom", "[", 
   RowBox[{"10", ",", "10", ",", 
    RowBox[{"pesos", "->", "True"}], ",", 
    RowBox[{"letras", "->", "True"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo10", ",", "\"\<grafo10.tex\>\"", ",", 
    RowBox[{"\"\<EdgeWeightSize\>\"", "->", "\"\<Large\>\""}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<white\>\""}], ",", 
    RowBox[{"\"\<EdgeWeightColor\>\"", "->", "\"\<magenta\>\""}], ",", 
    RowBox[{"\"\<GraphScale\>\"", "->", "1.5"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9670555254805317`*^9, 3.9670555291113167`*^9}, {
   3.96705622841617*^9, 3.9670562321984873`*^9}, {3.96705688682749*^9, 
   3.9670568871127377`*^9}, 3.967058899219314*^9, {3.967058953658729*^9, 
   3.9670589644544497`*^9}, {3.967058998376028*^9, 3.9670590655907173`*^9}, {
   3.967059112263764*^9, 3.9670591362475452`*^9}, {3.967059203236494*^9, 
   3.967059219822672*^9}, {3.967059294227463*^9, 3.96705939485364*^9}, 
   3.967059515100172*^9, 3.9670595721322937`*^9, {3.967108029647091*^9, 
   3.967108162312153*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"8a4c3f5d-db8e-4f62-8d84-6cdd1c58b70b"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`e, $CellContext`f, $CellContext`g, $CellContext`h, \
$CellContext`i, $CellContext`j}, {
      Null, {{1, 4}, {2, 4}, {2, 8}, {2, 10}, {3, 5}, {3, 8}, {3, 10}, {4, 
       6}, {7, 8}, {7, 10}}}, {
      EdgeLabels -> {
        UndirectedEdge[$CellContext`d, $CellContext`f] -> 37, 
         UndirectedEdge[$CellContext`a, $CellContext`d] -> 18, 
         UndirectedEdge[$CellContext`g, $CellContext`j] -> 8, 
         UndirectedEdge[$CellContext`c, $CellContext`j] -> 29, 
         UndirectedEdge[$CellContext`b, $CellContext`j] -> 12, 
         UndirectedEdge[$CellContext`c, $CellContext`h] -> 25, 
         UndirectedEdge[$CellContext`c, $CellContext`e] -> 24, 
         UndirectedEdge[$CellContext`b, $CellContext`d] -> 32, 
         UndirectedEdge[$CellContext`b, $CellContext`h] -> 39, 
         UndirectedEdge[$CellContext`g, $CellContext`h] -> 41}, 
       EdgeWeight -> {18, 32, 39, 12, 24, 25, 29, 37, 41, 8}, ImagePadding -> 
       10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], {
         {Arrowheads[0.], 
          ArrowBox[{{5.331239455239564, -1.8403998422284318`}, {
           4.584971868756207, -1.2378947126780941`}}, 0.043089454602127666`]},
          InsetBox["18", {4.958105661997886, -1.5391472774532629}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.270932848395592, -1.143148251352714}, {
           4.584971868756207, -1.2378947126780941`}}, 0.043089454602127666`]},
          InsetBox["32", {3.9279523585758995, -1.190521482015404}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.270932848395592, -1.143148251352714}, {
           2.2008056820425916`, -1.2716494127834808`}}, 
           0.043089454602127666`]}, 
         InsetBox["39", {2.735869265219092, -1.2073988320680975}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{3.270932848395592, -1.143148251352714}, {
           2.276300089353758, -0.8316232632152247}}, 0.043089454602127666`]}, 
         InsetBox["12", {2.773616468874675, -0.9873857572839694}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.3468861242684942`, -1.372617314392713}, {
           0.40281107795453597`, -1.6991814718624143`}}, 
           0.043089454602127666`]}, 
         InsetBox["24", {0.8748486011115151, -1.5358993931275635}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.3468861242684942`, -1.372617314392713}, {
           2.2008056820425916`, -1.2716494127834808`}}, 
           0.043089454602127666`]}, 
         InsetBox["25", {1.773845903155543, -1.322133363588097}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.3468861242684942`, -1.372617314392713}, {
           2.276300089353758, -0.8316232632152247}}, 0.043089454602127666`]}, 
         InsetBox["29", {1.8115931068111262, -1.102120288803969}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{4.584971868756207, -1.2378947126780941`}, {
           5.410039560953211, -0.7473956737388556}}, 0.043089454602127666`]}, 
         InsetBox["37", {4.997505714854709, -0.9926451932084749}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.8264518824118239`, -0.40281107795453575`}, {
           2.2008056820425916`, -1.2716494127834808`}}, 
           0.043089454602127666`]}, 
         InsetBox["41", {2.0136287822272076, -0.8372302453690083}, 
          ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}, {
         {Arrowheads[0.], 
          ArrowBox[{{1.8264518824118239`, -0.40281107795453575`}, {
           2.276300089353758, -0.8316232632152247}}, 0.043089454602127666`]}, 
         InsetBox["8", {2.051375985882791, -0.6172171705848802}, ImageScaled[{0.5, 0.5}],
          BaseStyle->"Graphics"]}}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{5.331239455239564, -1.8403998422284318`}, 
          0.043089454602127666], 
         InsetBox["a", 
          Offset[{2, 2}, {5.374328909841692, -1.7973103876263041}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.270932848395592, -1.143148251352714}, 
          0.043089454602127666], 
         InsetBox["b", 
          Offset[{2, 2}, {3.31402230299772, -1.1000587967505864}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.3468861242684942`, -1.372617314392713}, 
          0.043089454602127666], 
         InsetBox["c", 
          Offset[{2, 2}, {1.3899755788706218, -1.3295278597905853}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.584971868756207, -1.2378947126780941`}, 
          0.043089454602127666], 
         InsetBox["d", 
          Offset[{2, 2}, {4.6280613233583345, -1.1948052580759665}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.40281107795453597`, -1.6991814718624143`}, 
          0.043089454602127666], 
         InsetBox["e", 
          Offset[{2, 2}, {0.4459005325566636, -1.6560920172602867}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{5.410039560953211, -0.7473956737388556}, 
          0.043089454602127666], 
         InsetBox["f", 
          Offset[{2, 2}, {5.453129015555339, -0.704306219136728}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8264518824118239`, -0.40281107795453575`}, 
          0.043089454602127666], 
         InsetBox["g", 
          Offset[{2, 2}, {1.8695413370139515, -0.3597216233524081}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.2008056820425916`, -1.2716494127834808`}, 
          0.043089454602127666], 
         InsetBox["h", 
          Offset[{2, 2}, {2.2438951366447193, -1.228559958181353}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.4028110779545357, -2.646021998137503}, 
          0.043089454602127666], 
         InsetBox["i", 
          Offset[{2, 2}, {0.44590053255666334, -2.6029325435353754}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.276300089353758, -0.8316232632152247}, 
          0.043089454602127666], 
         InsetBox["j", 
          Offset[{2, 2}, {2.319389543955886, -0.7885338086130971}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.9670589003682537`*^9, 3.967058970585415*^9, {3.967059017687875*^9, 
   3.9670590659985447`*^9}, {3.9670591134439898`*^9, 3.9670591602982483`*^9}, 
   3.967059223169806*^9, {3.967059294929351*^9, 3.967059337228853*^9}, {
   3.967059369004177*^9, 3.967059411917591*^9}, {3.9670595071361723`*^9, 
   3.967059534971631*^9}, 3.967059573131892*^9, 3.967105944160626*^9, {
   3.9671080305957003`*^9, 3.9671081637990837`*^9}, {3.9671094735272627`*^9, 
   3.96710948155849*^9}},
 CellLabel->"Out[46]=",ExpressionUUID->"4b98f525-483e-47c7-b096-77fe6eb9ebe6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.9671094815792217`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"a2cb9a63-f859-4d5d-92ee-d43635bfa5f8"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.967109481579761*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"bafd3314-4f94-423e-82d1-43fdde774b90"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.967109481580349*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"71def0af-7f9b-41e6-8739-8925381f4419"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.96710948158069*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"03ab8ff4-3eae-47a5-8a8e-1ec144204e97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.967109481581026*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"66b1201f-9f53-48b8-b143-60c658acc9a7"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.967109481643269*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"dd954f92-201f-46b5-a913-9737ffcab9a2"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.9671094826499147`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"961b6589-4680-41e7-8335-edb71397a6ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo10/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo10/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.967109482653503*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"0bc40c60-debd-42f5-9930-4fbf1b101279"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo10\"\>"}],
  SequenceForm["Archivo: ", "grafo10"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.967109482655677*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"60314599-6b0b-45fd-9ae8-2a139c205da7"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.967109483147896*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"affcb6b6-2229-46fe-8473-336867b0ebf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo10/grafo10.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo10/grafo10.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108030615692*^9, 3.9671081638208723`*^9}, {
  3.967109473549271*^9, 3.967109483148477*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[46]:=",ExpressionUUID->"f19fd490-651e-4e70-afd3-ec72d3b281bc"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo10/grafo10.pdf\"\
\>"], "Output",
 CellChangeTimes->{
  3.9670589003682537`*^9, 3.967058970585415*^9, {3.967059017687875*^9, 
   3.9670590659985447`*^9}, {3.9670591134439898`*^9, 3.9670591602982483`*^9}, 
   3.967059223169806*^9, {3.967059294929351*^9, 3.967059337228853*^9}, {
   3.967059369004177*^9, 3.967059411917591*^9}, {3.9670595071361723`*^9, 
   3.967059534971631*^9}, 3.967059573131892*^9, 3.967105944160626*^9, {
   3.9671080305957003`*^9, 3.9671081637990837`*^9}, {3.9671094735272627`*^9, 
   3.967109483160446*^9}},
 CellLabel->"Out[48]=",ExpressionUUID->"fc2346c3-1364-495d-b0e5-31f6fcf8618a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 11: sin etiquetas en los nodos", "Subsection",
 CellChangeTimes->{{3.9670555383180523`*^9, 
  3.967055560757785*^9}},ExpressionUUID->"07e1fe11-9e61-4468-bb69-\
30abaa8cde4d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo11", "=", 
  RowBox[{"Grafo", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "15"}], "}"}]}], "}"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo11", ",", "\"\<grafo11.tex\>\"", ",", 
    RowBox[{"\"\<VertexLabels\>\"", "->", "False"}], ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<yellow\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<cyan\>\""}], ",", 
    RowBox[{"\"\<Directed\>\"", "->", "False"}], ",", 
    RowBox[{"\"\<GraphScale\>\"", "->", "2"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.967055565427565*^9, 3.967055570770245*^9}, 
   3.967056235751314*^9, {3.967056890533781*^9, 3.967056890820805*^9}, 
   3.967059491735924*^9, 3.967105114426827*^9, {3.967108199215761*^9, 
   3.9671082901779413`*^9}, {3.967108361346211*^9, 3.967108393188773*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"97adc1f5-2e37-4b8e-ae12-1064943c513a"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 6, 8, 3, 9, 4, 5, 7, 14, 10, 15, 13, 11, 12}, {
      Null, {{1, 2}, {1, 3}, {2, 3}, {2, 4}, {5, 6}, {7, 8}, {7, 9}, {7, 6}, {
       7, 10}, {8, 4}, {8, 11}, {8, 10}, {3, 12}, {9, 6}, {6, 13}, {11, 13}, {
       14, 15}, {14, 12}, {13, 12}, {10, 12}}}, {
      ImagePadding -> 10, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[0.], 
        ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGAQAWImKM6cEvNzspSIw4n59Q1zmbkc9NxVRPiqBB127Ana
Mq+OxwFdXvaukLZpuKDDQaf9/FcnsmKoJyTvnsmj8syM20HgteHHnNV8GOqP
KdWzK5/ncuhLl+y+de2vPbr6h8a7/TJkmB3W1y03s6/kcmCAAjE789377v+0
f7N6whzr0Lf26UorFcKaGBzQ+V0lpz6uWvPdXmPWo2tGDWwY8mtyzx+Zs+qR
/TaB73XnH7JiyPMYO+x7P5/BgVOn5P76yX/t0c1Ddx+6PLr56PLei7M1ojJZ
HL4K7as8s5AFwzxC8lzFgs0qGgwODGvsC4/wsWKoRw9fdPXo/kNXT0j+luru
XeHcAg4FO3r39C98icFf66alFMwvBI83AItPB7o=
         "], 0.04319636893374185]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{5.0259551012760335`, 3.2517652548740195`}, 
          0.04319636893374185], 
         InsetBox["1", 
          Offset[{2, 2}, {5.069151470209776, 3.2949616238077613}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.369194330896603, 3.5618261420964608`}, 
          0.04319636893374185], 
         InsetBox["2", 
          Offset[{2, 2}, {4.412390699830345, 3.6050225110302025}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.335163758303023, 2.6962071638339187`}, 
          0.04319636893374185], 
         InsetBox["6", 
          Offset[{2, 2}, {4.378360127236765, 2.7394035327676605}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.401806146267663, 3.833703884445079}, 0.04319636893374185],
          InsetBox["8", 
          Offset[{2, 2}, {3.4450025152014048, 3.8769002533788206}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.6171252549282875`}, 0.04319636893374185], 
         InsetBox["3", 
          Offset[{2, 2}, {0.04319636893374185, 1.6603216238620293}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9166544015801015, 2.0636408378234594`}, 
          0.04319636893374185], 
         InsetBox["9", 
          Offset[{2, 2}, {0.9598507705138433, 2.106837206757201}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.4796552128748623`, 2.8125969684508796`}, 
          0.04319636893374185], 
         InsetBox["4", 
          Offset[{2, 2}, {1.5228515818086041, 2.8557933373846214}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.3888708258514133`, 3.3092026014199614`}, 
          0.04319636893374185], 
         InsetBox["5", Offset[{2, 2}, {2.432067194785155, 3.352398970353703}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.5833267063093692, 2.7352590483806933`}, 
          0.04319636893374185], 
         InsetBox["7", Offset[{2, 2}, {0.626523075243111, 2.778455417314435}],
           ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.551441493782851, 2.579003287423229}, 0.04319636893374185],
          InsetBox["14", 
          Offset[{2, 2}, {2.594637862716593, 2.6221996563569707}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.019600891084683, 2.632210621600734}, 0.04319636893374185],
          InsetBox["10", 
          Offset[{2, 2}, {2.062797260018425, 2.675406990534476}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.3511410318063524`, 1.8649545129360123`}, 
          0.04319636893374185], 
         InsetBox["15", 
          Offset[{2, 2}, {3.394337400740094, 1.9081508818697541}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.078093992552004, 1.848556397310633}, 0.04319636893374185],
          InsetBox["13", 
          Offset[{2, 2}, {2.121290361485746, 1.8917527662443747}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.0110768486715305`, 0.8009718592345632}, 
          0.04319636893374185], 
         InsetBox["11", 
          Offset[{2, 2}, {4.054273217605273, 0.844168228168305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.514965566473319, 0.}, 0.04319636893374185], 
         InsetBox["12", 
          Offset[{2, 2}, {4.558161935407061, 0.04319636893374185}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.967059424970295*^9, 3.9670594920990477`*^9, {3.967108210557342*^9, 
   3.967108219291278*^9}, {3.967108258698262*^9, 3.967108291048298*^9}, {
   3.967108366472395*^9, 3.967108393608983*^9}, 3.967109493356304*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"682ae0f9-5dcf-45ed-b7ee-c5b5a64b3db8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.9671094933780527`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"1626eded-c130-49c2-af4a-7c6c35ff6e9c"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.967109493378551*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"0c0f28b0-3913-417e-bfc8-384444897667"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.967109493379085*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"66ba596a-6935-4fb5-ac98-66230e31c451"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.967109493379403*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"d6069222-8aa1-4a41-a05c-c1be3c49cc26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.9671094933797197`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"0105ff20-ea67-4cda-bf9b-886584553ed6"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.9671094934604177`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"02306f5e-9f47-4947-b635-4d2b0d56eda3"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.967109494466558*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"88c45a73-fdf4-4d22-9477-5604710c45f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo11/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo11/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.96710949446973*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"b4d7737f-40b1-493b-bf39-1b6b601f1841"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo11\"\>"}],
  SequenceForm["Archivo: ", "grafo11"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.9671094944718657`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"d2666bd2-cad7-4578-ae38-6185a55d794d"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.967109494825492*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"7d2e005f-435a-475d-beab-e6f632ae78f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo11/grafo11.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo11/grafo11.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967059425000519*^9, 3.9670594921054792`*^9, {3.96710821057996*^9, 
   3.967108219312695*^9}, {3.967108258704219*^9, 3.967108291053845*^9}, {
   3.9671083665000877`*^9, 3.96710839363421*^9}, 3.967109494826063*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[49]:=",ExpressionUUID->"02a06123-3d5f-443e-b5b8-0f54caa6feee"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo11/grafo11.pdf\"\
\>"], "Output",
 CellChangeTimes->{
  3.967059424970295*^9, 3.9670594920990477`*^9, {3.967108210557342*^9, 
   3.967108219291278*^9}, {3.967108258698262*^9, 3.967108291048298*^9}, {
   3.967108366472395*^9, 3.967108393608983*^9}, 3.9671094948384047`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"076b709a-fbe7-48b3-a372-ddc40ee72dc6"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 12: tipo especial", "Subsection",
 CellChangeTimes->{{3.9670555383180523`*^9, 
  3.96705560075032*^9}},ExpressionUUID->"3fa4bec0-b663-40db-8099-\
11fbdeaab78a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo12", "=", 
  RowBox[{"GrafoDato", "[", 
   RowBox[{"tipo", "->", "\"\<FruchtGraph\>\""}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo12", ",", "\"\<grafo12.tex\>\"", ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<green\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<red\>\""}], ",", 
    RowBox[{"\"\<VertexLabels\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<VertexSize\>\"", "->", "0.3"}], ",", 
    RowBox[{"\"\<GraphScale\>\"", "->", "2"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9647720283944626`*^9, 3.96477204599387*^9}, {
   3.967054748037072*^9, 3.9670547755215673`*^9}, 3.9670549385841713`*^9, 
   3.967055050805889*^9, {3.9670551003915977`*^9, 3.967055107275166*^9}, 
   3.967055153835568*^9, {3.967055303857524*^9, 3.967055412224934*^9}, {
   3.967055519544263*^9, 3.96705554646915*^9}, {3.967055576873129*^9, 
   3.9670556244541388`*^9}, 3.96705617732225*^9, 3.967059473716256*^9, 
   3.967105117593322*^9, {3.967108422903544*^9, 3.9671085272457333`*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"38bb44b8-f46e-45ca-af88-ea9f5c46a2bb"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, {Null, 
       SparseArray[
       Automatic, {12, 12}, 0, {
        1, {{0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30, 33, 36}, {{2}, {7}, {
          11}, {1}, {3}, {8}, {2}, {4}, {9}, {3}, {5}, {9}, {4}, {6}, {10}, {
          5}, {7}, {10}, {1}, {6}, {11}, {2}, {11}, {12}, {3}, {4}, {12}, {
          5}, {6}, {12}, {1}, {7}, {8}, {8}, {9}, {10}}}, Pattern}]}, {
      GraphLayout -> {"Dimension" -> 2}, ImagePadding -> 10, 
       VertexCoordinates -> {{0.782, 0.624}, {0., 1.}, {-0.782, 
        0.623}, {-0.975, -0.223}, {-0.434, -0.901}, {0.434, -0.901}, {
        0.975, -0.222}, {0.089, 0.39}, {-0.39, 0.089}, {-0.089, -0.39}, {
        0.39, -0.089}, {-0.086, 0.071}}, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[0.], 
        ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGAQAmImKF4gpX9Xhe2lvXa72M1z3x/bM6CAD/bo8sZg8N7+
otLtn3VZZ/ajy3/TiOk/9PWGfZJAhOWWE9v24zBvfxif7qa57zHtg+qDm4Ou
Hmr/flW2xqnO3XD74fJQffth5qCrB6lafuz2/kWu2z7/vfJmP7o8un509VC+
PRofLg/zN8wcdPXo4Ycuj64fXT16+KKHFyH5rD0lkyVYtu0HEqAgwwgvdHl0
96DLAwB7DBvb
         "], 0.02220447284345045]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0.782, 0.624}, 0.02220447284345045], 
         InsetBox["1", 
          Offset[{2, 2}, {0.8042044728434505, 0.6462044728434504}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.02220447284345045], 
         InsetBox["2", 
          Offset[{2, 2}, {0.02220447284345045, 1.0222044728434505}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.782, 0.623}, 0.02220447284345045], 
         InsetBox["3", 
          Offset[{2, 2}, {-0.7597955271565495, 0.6452044728434505}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.975, -0.223}, 0.02220447284345045], 
         InsetBox["4", 
          Offset[{2, 2}, {-0.9527955271565496, -0.20079552715654955}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.434, -0.901}, 0.02220447284345045], 
         InsetBox["5", 
          Offset[{2, 2}, {-0.41179552715654955, -0.8787955271565495}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.434, -0.901}, 0.02220447284345045], 
         InsetBox["6", 
          Offset[{2, 2}, {0.45620447284345045, -0.8787955271565495}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.975, -0.222}, 0.02220447284345045], 
         InsetBox["7", 
          Offset[{2, 2}, {0.9972044728434504, -0.19979552715654955}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.089, 0.39}, 0.02220447284345045], 
         InsetBox["8", 
          Offset[{2, 2}, {0.11120447284345045, 0.41220447284345046}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.39, 0.089}, 0.02220447284345045], 
         InsetBox["9", 
          Offset[{2, 2}, {-0.36779552715654956, 0.11120447284345045}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.089, -0.39}, 0.02220447284345045], 
         InsetBox["10", 
          Offset[{2, 2}, {-0.06679552715654954, -0.36779552715654956}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.39, -0.089}, 0.02220447284345045], 
         InsetBox["11", 
          Offset[{2, 2}, {0.41220447284345046, -0.06679552715654954}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.086, 0.071}, 0.02220447284345045], 
         InsetBox["12", 
          Offset[{2, 2}, {-0.06379552715654954, 0.09320447284345044}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.967059438714888*^9, 3.967059474102838*^9, 3.9671059302040443`*^9, {
   3.967108496683586*^9, 3.967108528628948*^9}, 3.9671095109465027`*^9, 
   3.967109948862258*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"0bf9d912-db49-4a56-bc37-09ab8417ce63"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.967109948866171*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"98945ebd-4d16-4462-806d-eb076417a429"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.967109948867144*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"d1541bc3-fb6c-400f-9e65-c1656250eb48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.967109948867732*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"7fbd6d28-0f25-4aa9-bccb-ea0b002e52b9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.967109948868133*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"41cc2389-2572-4651-ad8d-95750d8a31d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.9671099488685093`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"c89e00db-ef2a-42c1-b893-cdb81bdd268b"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.967109948966467*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"5a77f68a-859e-4e6a-b8e5-15fda24036ee"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.967109949972027*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"0eb9be1e-7ab0-40c1-a539-2162e74e80db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo12/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo12/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.9671099499750957`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"eb966f79-f1dc-40be-86f6-12ab70912f56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo12\"\>"}],
  SequenceForm["Archivo: ", "grafo12"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.967109949976823*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"915d26fc-2c93-403a-a183-d3683c0da1a4"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.9671099504663563`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"f19b90d1-5ec0-44ae-82b4-72e301d56844"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo12/grafo12.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo12/grafo12.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.967108496685008*^9, 3.9671085286332808`*^9}, 
   3.967109510949349*^9, 3.9671099504669733`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[88]:=",ExpressionUUID->"13c41cf1-bcf4-4fa4-97bd-2991904632cc"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo12/grafo12.pdf\"\
\>"], "Output",
 CellChangeTimes->{
  3.967059438714888*^9, 3.967059474102838*^9, 3.9671059302040443`*^9, {
   3.967108496683586*^9, 3.967108528628948*^9}, 3.9671095109465027`*^9, 
   3.9671099504791737`*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"18ca12c8-e374-4246-99be-bd55cc2650ac"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 13: tipo especial", "Subsection",
 CellChangeTimes->{{3.9670555383180523`*^9, 3.96705560075032*^9}, 
   3.9670556392295303`*^9},ExpressionUUID->"498cddc4-9a73-4f0c-9894-\
236d8250ca13"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo13", "=", 
  RowBox[{"GrafoDato", "[", 
   RowBox[{"tipo", "->", "\"\<GroetzschGraph\>\""}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo13", ",", "\"\<grafo13.tex\>\"", ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<gray\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<purple\>\""}], ",", 
    RowBox[{"\"\<VertexLabels\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<VertexSize\>\"", "->", "0.3"}], ",", 
    RowBox[{"\"\<GraphScale\>\"", "->", "2.5"}], ",", 
    RowBox[{"\"\<EdgeStyle\>\"", "->", "\"\<dashed\>\""}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9647720283944626`*^9, 3.96477204599387*^9}, {
   3.967054748037072*^9, 3.9670547755215673`*^9}, 3.9670549385841713`*^9, 
   3.967055050805889*^9, {3.9670551003915977`*^9, 3.967055107275166*^9}, 
   3.967055153835568*^9, {3.967055303857524*^9, 3.967055412224934*^9}, {
   3.967055519544263*^9, 3.96705554646915*^9}, {3.967055576873129*^9, 
   3.9670556244541388`*^9}, {3.967055663636792*^9, 3.967055677120308*^9}, 
   3.967056173755179*^9, 3.96705945736021*^9, {3.967108544354712*^9, 
   3.967108659255739*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"0e79a95f-e8d6-47d7-931c-936bc2e79c2f"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {Null, 
       SparseArray[
       Automatic, {11, 11}, 0, {
        1, {{0, 4, 8, 12, 16, 20, 25, 28, 31, 34, 37, 40}, {{2}, {3}, {8}, {
          11}, {1}, {4}, {7}, {10}, {1}, {5}, {7}, {9}, {2}, {5}, {9}, {11}, {
          3}, {4}, {8}, {10}, {7}, {8}, {9}, {10}, {11}, {2}, {3}, {6}, {1}, {
          5}, {6}, {3}, {4}, {6}, {2}, {5}, {6}, {1}, {4}, {6}}}, 
         Pattern}]}, {
      GraphLayout -> {"Dimension" -> 2}, ImagePadding -> 10, 
       VertexCoordinates -> {{(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
          Root[5 - 20 #^2 + 16 #^4& , 2, 0], 
          Rational[1, 4] (-1 - 5^Rational[1, 2])}, {0, 1}, {
         Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
           Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 0}, {
         Rational[1, 4] (5 - 2 5^Rational[1, 2])^Rational[1, 2], 
          Rational[-1, 4]}, {
         Rational[-1, 4] (5 - 2 5^Rational[1, 2])^Rational[1, 2], 
          Rational[-1, 4]}, {
          Root[5 - 80 #^2 + 256 #^4& , 2, 0], 
          Rational[1, 8] (3 - 5^Rational[1, 2])}, {
         0, Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
          Root[5 - 80 #^2 + 256 #^4& , 3, 0], 
          Rational[1, 8] (3 - 5^Rational[1, 2])}}, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[0.], 
        ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGAQAWImKI6LKmVRPv/IfsWX6bPLH7/c/z/ERZgv/519wEt9
8/fHLtujy0P5+9H4cHmnr3Nlr9kf388ABhcw5CH8S/YJugsmKhbtsEe3jwEF
fMCQh5pvDzMfl3409+9H899+XPLo5mP376X9MPfjcO9+XP4hpB9H+OxH8z88
fHHZh91+BgZ0/+GQ349LHr/7EQCX/ej+AwAkiumt
         "], 0.021812234931106983`]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.5877852522924731, -0.8090169943749475}, 
          0.021812234931106983], 
         InsetBox["1", 
          Offset[{2, 2}, {0.6095974872235801, -0.7872047594438405}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9510565162951535, 0.30901699437494745`}, 
          0.021812234931106983], 
         InsetBox["2", 
          Offset[{2, 2}, {0.9728687512262605, 0.3308292293060544}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.5877852522924731, -0.8090169943749475}, 
          0.021812234931106983], 
         InsetBox["3", 
          Offset[{2, 2}, {-0.5659730173613662, -0.7872047594438405}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 1.}, 0.021812234931106983], 
         InsetBox["4", 
          Offset[{2, 2}, {0.021812234931106983, 1.021812234931107}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.9510565162951535, 0.30901699437494745`}, 
          0.021812234931106983], 
         InsetBox["5", 
          Offset[{2, 2}, {-0.9292442813640466, 0.3308292293060544}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.}, 0.021812234931106983], 
         InsetBox["6", 
          Offset[{2, 2}, {0.021812234931106983, 0.021812234931106983}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.1816356320013402, -0.25}, 0.021812234931106983], 
         InsetBox["7", 
          Offset[{2, 2}, {0.20344786693244718, -0.22818776506889302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.1816356320013402, -0.25}, 0.021812234931106983], 
         InsetBox["8", 
          Offset[{2, 2}, {-0.15982339707023321, -0.22818776506889302}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.29389262614623657`, 0.09549150281252627}, 
          0.021812234931106983], 
         InsetBox["9", 
          Offset[{2, 2}, {-0.2720803912151296, 0.11730373774363326}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.30901699437494745`}, 0.021812234931106983], 
         InsetBox["10", 
          Offset[{2, 2}, {0.021812234931106983, 0.3308292293060544}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.29389262614623657`, 0.09549150281252627}, 
          0.021812234931106983], 
         InsetBox["11", 
          Offset[{2, 2}, {0.3157048610773435, 0.11730373774363326}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{{3.967059447391675*^9, 3.967059457833331*^9}, {
   3.967108570218835*^9, 3.967108597218803*^9}, 3.967108660389985*^9, 
   3.967109519332361*^9, 3.967109956886104*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"e73ebee0-41fe-4271-9a3e-0164a6169c27"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.967109956887843*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"ec8ceb0a-3b23-4569-b31f-713626f46570"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.96710995688843*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"38b71e0c-58ce-4ad1-aa31-a892c23e1f1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.9671099568890533`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"7f65b20c-1ce9-4187-bd80-bc75822f22b1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.967109956889464*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"5ad9f659-15e8-48e2-8b1e-dfeefb419f04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.967109956889883*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"b4fe3640-db86-4ed7-a2ca-033410acf119"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.967109956974601*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"30a6093b-a351-4e40-906c-281fab710a64"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.9671099579803143`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"74aaf00c-873e-4502-a421-aadc44fb145b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo13/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo13/"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.967109957983341*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"46d27836-898d-4423-8dfe-25dccaa34e7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo13\"\>"}],
  SequenceForm["Archivo: ", "grafo13"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.967109957985766*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"6e2efb6c-8dcd-4d88-8116-17fbf9f1ce16"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.967109958483832*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"6499dab1-ab56-4199-b72c-cec54f344412"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo13/grafo13.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo13/grafo13.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9670594473940496`*^9, 3.967059457835438*^9}, {
   3.9671085702225847`*^9, 3.967108597222459*^9}, 3.967108660396624*^9, 
   3.967109519335775*^9, 3.9671099584844418`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[91]:=",ExpressionUUID->"8bb95386-64cb-40d0-b12b-4ff37b75dbf0"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo13/grafo13.pdf\"\
\>"], "Output",
 CellChangeTimes->{{3.967059447391675*^9, 3.967059457833331*^9}, {
   3.967108570218835*^9, 3.967108597218803*^9}, 3.967108660389985*^9, 
   3.967109519332361*^9, 3.967109958497492*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"c37a2835-eb89-414a-80d4-13696aab9bee"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 14: tipo especial", "Subsection",
 CellChangeTimes->{{3.9670555383180523`*^9, 3.96705560075032*^9}, 
   3.9670556392295303`*^9, 
   3.967109540818076*^9},ExpressionUUID->"1abdddcd-68b6-4073-8362-\
12f79fc556d7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo14", "=", 
  RowBox[{"GrafoDato", "[", 
   RowBox[{"tipo", "->", "\"\<SmallestCyclicGroupGraph\>\""}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo14", ",", "\"\<grafo14.tex\>\"", ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<white\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<purple\>\""}], ",", 
    RowBox[{"\"\<VertexLabels\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<VertexSize\>\"", "->", "0.3"}], ",", 
    RowBox[{"\"\<GraphScale\>\"", "->", "2.5"}], ",", 
    RowBox[{"\"\<EdgeStyle\>\"", "->", "\"\<thick\>\""}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9647720283944626`*^9, 3.96477204599387*^9}, {
   3.967054748037072*^9, 3.9670547755215673`*^9}, 3.9670549385841713`*^9, 
   3.967055050805889*^9, {3.9670551003915977`*^9, 3.967055107275166*^9}, 
   3.967055153835568*^9, {3.967055303857524*^9, 3.967055412224934*^9}, {
   3.967055519544263*^9, 3.96705554646915*^9}, {3.967055576873129*^9, 
   3.9670556244541388`*^9}, {3.967055663636792*^9, 3.967055677120308*^9}, 
   3.967056173755179*^9, 3.96705945736021*^9, {3.967108544354712*^9, 
   3.967108659255739*^9}, {3.967109549074307*^9, 3.967109632909556*^9}, {
   3.9671097367759867`*^9, 3.9671097537694902`*^9}, {3.967109795623576*^9, 
   3.96710980049216*^9}, {3.96710984817233*^9, 3.967109865445525*^9}, 
   3.967109910596918*^9, {3.9671099687382603`*^9, 3.967110006870153*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"a927117d-7898-4cf0-96a7-e41dea057a06"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {Null, 
       SparseArray[
       Automatic, {9, 9}, 0, {
        1, {{0, 5, 10, 15, 18, 20, 23, 25, 28, 30}, {{2}, {3}, {4}, {5}, {
          6}, {1}, {3}, {4}, {8}, {9}, {1}, {2}, {6}, {7}, {8}, {1}, {2}, {
          9}, {1}, {6}, {1}, {3}, {5}, {3}, {8}, {2}, {3}, {7}, {2}, {4}}}, 
         Pattern}]}, {
      GraphLayout -> {"Dimension" -> 2}, ImagePadding -> 10, 
       VertexCoordinates -> {{
          Rational[-1, 2], 0}, {
          Rational[1, 2], 0}, {0, Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[-1, 2], -1}, {Rational[1, 2] (-1 - 3^Rational[1, 2]), 
          Rational[1, 2]}, {
         Rational[-1, 2] 3^Rational[1, 2], 
          Rational[1, 2] (1 + 3^Rational[1, 2])}, {
         Rational[1, 2] 3^Rational[1, 2], 
          Rational[1, 2] (1 + 3^Rational[1, 2])}, {
         Rational[1, 2] (1 + 3^Rational[1, 2]), 
          Rational[1, 2]}, {
          Rational[1, 2], -1}}, VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[0.], 
        ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGDgB2ImKIaAB/sZUMADezQ+mjwDwyqfiBdV217b49AP5X/Y
jy4fqqZTYnv7K0wcQz/U3P1Qdfao6nDaj8O9H/ajy2M3F0O/Pap+hH3Y3Ych
b49LHof9ONz7YT96eKHbj24uuvkASKR2vQ==
         "], 0.028286647027724224`]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{-0.5, 0.}, 0.028286647027724224], 
         InsetBox["1", 
          Offset[{2, 2}, {-0.4717133529722758, 0.028286647027724224}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0.5, 0.}, 0.028286647027724224], 
         InsetBox["2", 
          Offset[{2, 2}, {0.5282866470277242, 0.028286647027724224}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.8660254037844386}, 0.028286647027724224], 
         InsetBox["3", 
          Offset[{2, 2}, {0.028286647027724224, 0.8943120508121628}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.5, -1.}, 0.028286647027724224], 
         InsetBox["4", 
          Offset[{2, 2}, {-0.4717133529722758, -0.9717133529722758}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-1.3660254037844386`, 0.5}, 0.028286647027724224], 
         InsetBox["5", 
          Offset[{2, 2}, {-1.3377387567567143, 0.5282866470277242}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.8660254037844386, 1.3660254037844386`}, 
          0.028286647027724224], 
         InsetBox["6", 
          Offset[{2, 2}, {-0.8377387567567144, 1.394312050812163}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8660254037844386, 1.3660254037844386`}, 
          0.028286647027724224], 
         InsetBox["7", 
          Offset[{2, 2}, {0.8943120508121628, 1.394312050812163}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.3660254037844386`, 0.5}, 0.028286647027724224], 
         InsetBox["8", 
          Offset[{2, 2}, {1.394312050812163, 0.5282866470277242}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0.5, -1.}, 0.028286647027724224],
          InsetBox["9", 
          Offset[{2, 2}, {0.5282866470277242, -0.9717133529722758}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.9671096393838053`*^9, {3.967109737858631*^9, 3.9671097545494757`*^9}, 
   3.967109800950539*^9, {3.967109849250763*^9, 3.967109869179511*^9}, 
   3.967109911019487*^9, 3.967109971988967*^9, 3.967110007698542*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"121dc3b8-ecd8-4f9f-98b5-396ebc9279de"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.9671100077019043`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"996198bc-3bf6-4215-a60a-9792934917e9"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110007702832*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"68b244e4-59be-48fd-929f-6e492b5f1fad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110007703431*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"beaf6566-17e7-4120-9d17-43831b30466b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110007703817*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"3c07ace4-f133-4d78-b9b6-5a178b92c5ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110007704198*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"88c13427-c54b-4195-ad55-6b29e3e42e92"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110007767426*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"8adedcb8-850f-4193-aede-a5ee9c7270de"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110008770441*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"06a41907-822e-4f38-8819-a7927fc11c9d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo14/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo14/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110008773287*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"a07b8d45-3962-4458-8f79-84778a37d8d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo14\"\>"}],
  SequenceForm["Archivo: ", "grafo14"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110008775319*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"cc8110a7-706e-4967-8321-39212d3bea52"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.967110009255475*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"87791ce7-c8ea-45e8-8407-a43895695ed7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo14/grafo14.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo14/grafo14.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109639388863*^9, {3.967109737863921*^9, 3.967109754555131*^9}, 
   3.967109800956028*^9, {3.96710984925412*^9, 3.96710986918082*^9}, 
   3.967109911042712*^9, 3.96710997199931*^9, 3.96711000925607*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[97]:=",ExpressionUUID->"b42e417b-8cd0-4a09-a5f1-6e5dae0f9149"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo14/grafo14.pdf\"\
\>"], "Output",
 CellChangeTimes->{
  3.9671096393838053`*^9, {3.967109737858631*^9, 3.9671097545494757`*^9}, 
   3.967109800950539*^9, {3.967109849250763*^9, 3.967109869179511*^9}, 
   3.967109911019487*^9, 3.967109971988967*^9, 3.9671100092682877`*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"b8ac4585-9c4f-4758-862f-07814ff80e36"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 15: tipo especial", "Subsection",
 CellChangeTimes->{{3.9670555383180523`*^9, 3.96705560075032*^9}, 
   3.9670556392295303`*^9, 
   3.967109545061181*^9},ExpressionUUID->"8945b796-8e9d-43a7-b545-\
a2ed38d373ca"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"grafo15", "=", 
  RowBox[{"GrafoDato", "[", 
   RowBox[{"tipo", "->", "\"\<PetersenGraph\>\""}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportGraphToTikZ", "[", 
   RowBox[{"grafo15", ",", "\"\<grafo15.tex\>\"", ",", 
    RowBox[{"\"\<VertexColor\>\"", "->", "\"\<orange\>\""}], ",", 
    RowBox[{"\"\<EdgeColor\>\"", "->", "\"\<blue\>\""}], ",", 
    RowBox[{"\"\<VertexLabels\>\"", "->", "True"}], ",", 
    RowBox[{"\"\<VertexSize\>\"", "->", "0.3"}], ",", 
    RowBox[{"\"\<GraphScale\>\"", "->", "2.5"}], ",", 
    RowBox[{"\"\<EdgeStyle\>\"", "->", "\"\<dotted\>\""}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9647720283944626`*^9, 3.96477204599387*^9}, {
   3.967054748037072*^9, 3.9670547755215673`*^9}, 3.9670549385841713`*^9, 
   3.967055050805889*^9, {3.9670551003915977`*^9, 3.967055107275166*^9}, 
   3.967055153835568*^9, {3.967055303857524*^9, 3.967055412224934*^9}, {
   3.967055519544263*^9, 3.96705554646915*^9}, {3.967055576873129*^9, 
   3.9670556244541388`*^9}, {3.967055663636792*^9, 3.967055677120308*^9}, 
   3.967056173755179*^9, 3.96705945736021*^9, {3.967108544354712*^9, 
   3.967108659255739*^9}, {3.967109557397853*^9, 3.967109562991692*^9}, 
   3.9671095973430643`*^9, 3.9671099290776577`*^9, {3.9671100187333317`*^9, 
   3.967110064888413*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"5d007e7d-9158-4ba9-923b-727688cdb386"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {Null, 
       SparseArray[
       Automatic, {10, 10}, 0, {
        1, {{0, 3, 6, 9, 12, 15, 18, 21, 24, 27, 30}, {{3}, {4}, {6}, {4}, {
          5}, {7}, {1}, {5}, {8}, {1}, {2}, {9}, {2}, {3}, {10}, {1}, {7}, {
          10}, {2}, {6}, {8}, {3}, {7}, {9}, {4}, {8}, {10}, {5}, {6}, {9}}}, 
         Pattern}]}, {
      GraphLayout -> {"Dimension" -> 2}, ImagePadding -> 10, 
       VertexCoordinates -> {{
          Rational[1, 2], 
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
         0, (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
         Rational[1, 5] Root[5 - 5 #^2 + #^4& , 3, 0], 
          Rational[1, 10] (-1 - 5^Rational[1, 2])}, {
         Rational[1, 4] (1 + 5^Rational[1, 2]), 
          Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {0, 
          Rational[2, 5]}, {
          Rational[-1, 2], 
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 
          Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
         Rational[-1, 5] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
           Rational[1, 2], Rational[1, 10] (-1 + 5^Rational[1, 2])}, {
         Rational[1, 5] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
           Rational[1, 2], Rational[1, 10] (-1 + 5^Rational[1, 2])}, {
          Root[1 - 25 #^2 + 125 #^4& , 2, 0], 
          Rational[1, 10] (-1 - 5^Rational[1, 2])}}, 
       VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.7], Opacity[0.7], CapForm["Round"], Arrowheads[0.], 
        ArrowBox[CompressedData["
1:eJxTTMoPSmVmYGDgB2ImKIaAB/aVq4t5VrI+22+gpcRuIXHOPiTWzfPn1iv7
0eVXfJk+u/zxS3ve4IW8py5dsEeXh/L3o/IZGJ4yu3F3WLy2x64fIQ/jz5oJ
Ajcx5KH698P0Y3cvQj+6/My7mfw3Im7sl3J69nHjkv0Y7oHK28PkcZi3Hy18
9qOFz3608NmPFr5w/ejq0d2Hg2+Pi49uPgANbM6S
         "], 0.019434941751084317`]}, 
       {Hue[0.6, 0.5, 1.], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0.5, -0.6881909602355868}, 0.019434941751084317], 
         InsetBox["1", 
          Offset[{2, 2}, {0.5194349417510843, -0.6687560184845025}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.85065080835204}, 0.019434941751084317], 
         InsetBox["2", 
          Offset[{2, 2}, {0.019434941751084317, 0.8700857501031243}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.23511410091698925`, -0.323606797749979}, 
          0.019434941751084317], 
         InsetBox["3", 
          Offset[{2, 2}, {0.25454904266807354, -0.30417185599889474}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.8090169943749475, 0.2628655560595668}, 
          0.019434941751084317], 
         InsetBox["4", 
          Offset[{2, 2}, {0.8284519361260317, 0.28230049781065114}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{0., 0.4}, 0.019434941751084317], 
         InsetBox["5", 
          Offset[{2, 2}, {0.019434941751084317, 0.4194349417510843}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.5, -0.6881909602355868}, 0.019434941751084317], 
         InsetBox["6", 
          Offset[{2, 2}, {-0.4805650582489157, -0.6687560184845025}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.8090169943749475, 0.2628655560595668}, 
          0.019434941751084317], 
         InsetBox["7", 
          Offset[{2, 2}, {-0.7895820526238632, 0.28230049781065114}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.3804226065180614, 0.12360679774997899`}, 
          0.019434941751084317], 
         InsetBox["8", 
          Offset[{2, 2}, {-0.3609876647669771, 0.1430417395010633}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.3804226065180614, 0.12360679774997899`}, 
          0.019434941751084317], 
         InsetBox["9", 
          Offset[{2, 2}, {0.39985754826914577, 0.1430417395010633}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-0.23511410091698925`, -0.323606797749979}, 
          0.019434941751084317], 
         InsetBox["10", 
          Offset[{2, 2}, {-0.21567915916590494, -0.30417185599889474}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->"NetworkGraphics",
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.967109775089697*^9, 3.967109930411224*^9, {3.9671100269805202`*^9, 
   3.967110065680069*^9}},
 CellLabel->
  "Out[109]=",ExpressionUUID->"30950fac-6171-4032-b9ca-6db2e68f1c58"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.967110065683771*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"e001c0f9-1e7f-474f-910e-3b30b933fd88"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.967110065684703*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"72e80f68-286d-44bc-a089-1f265fcd0e5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.967110065685335*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"cac4fc04-e963-4106-b21a-c92676ac8561"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.967110065685753*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"fa0cb892-0329-437a-a95d-773c98b85b9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.9671100656861687`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"213d9fd5-c409-49b6-b716-e7dee76ab69c"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.967110065748934*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"2a84e5c6-8276-429d-8271-ed045ab8f7e5"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.9671100667554903`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"fc94c911-0995-4e8a-a059-23773c53a7c1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo15/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo15/"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.967110066758684*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"70ab9379-49c6-455e-b65f-ae7c1a8913aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"grafo15\"\>"}],
  SequenceForm["Archivo: ", "grafo15"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.9671100667602997`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"d3b9b026-72c1-4abe-bc9b-2dca75578405"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.9671100672434587`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"d207b623-1595-465c-a30a-3c5e7ea3cb35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/grafo15/grafo15.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", 
   "/Users/enriquevilchezquesada/Downloads/grafo15/grafo15.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.967109775094181*^9, 3.967109930414771*^9, {3.9671100269842777`*^9, 
   3.9671100672442083`*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[109]:=",ExpressionUUID->"fcc9459f-9f60-482f-89a8-56e217137734"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/grafo15/grafo15.pdf\"\
\>"], "Output",
 CellChangeTimes->{
  3.967109775089697*^9, 3.967109930411224*^9, {3.9671100269805202`*^9, 
   3.9671100672567*^9}},
 CellLabel->
  "Out[111]=",ExpressionUUID->"0d91c99b-0249-4e4c-9bc3-84ebf1f9b6f0"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1463, 688},
WindowMargins->{{Automatic, 58}, {40, Automatic}},
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5420f22d-720b-4572-84cb-8f050efca9fa"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 301, 5, 99, "Input",ExpressionUUID->"ea6cdd64-a7ca-4aba-882e-f7e2070369f6"],
Cell[CellGroupData[{
Cell[902, 31, 1195, 33, 86, "Print",ExpressionUUID->"0c71df9b-7908-44bd-bf7d-265c611fe4dd"],
Cell[2100, 66, 421, 7, 46, "Print",ExpressionUUID->"5f58e1e9-be11-4e6e-b70c-a485291da373"],
Cell[2524, 75, 419, 7, 46, "Print",ExpressionUUID->"d8e6986b-725a-477b-a95f-eb2532d59c94"],
Cell[2946, 84, 660, 13, 46, "Print",ExpressionUUID->"7e9d829d-420a-41cb-805a-1baf9583712d"],
Cell[3609, 99, 697, 14, 46, "Print",ExpressionUUID->"191f4dba-f47f-4070-a882-4e7be0122095"],
Cell[4309, 115, 663, 13, 46, "Print",ExpressionUUID->"315b0e36-3ec8-459b-b250-0ce1d5d38186"],
Cell[4975, 130, 660, 13, 46, "Print",ExpressionUUID->"dd3a15ee-22db-405a-8645-33dc4f4a20a5"],
Cell[5638, 145, 1198, 33, 86, "Print",ExpressionUUID->"7619862d-62e2-43fc-9771-65b4594484c9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6885, 184, 430, 6, 136, "Subtitle",ExpressionUUID->"e620c90a-a47e-4279-8a06-c63909917048"],
Cell[CellGroupData[{
Cell[7340, 194, 204, 3, 58, "Input",ExpressionUUID->"295abe39-3f99-453c-80fa-f281dc6ba1cb"],
Cell[7547, 199, 125210, 2448, 4852, "Output",ExpressionUUID->"ad3867eb-5412-4b25-86bd-4b6ae6f4b9bb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132794, 2652, 179, 3, 106, "Subsection",ExpressionUUID->"e490c9e0-d08b-429b-ba27-9710ab2bc5a3"],
Cell[CellGroupData[{
Cell[132998, 2659, 1607, 33, 170, "Input",ExpressionUUID->"00da87b3-93cf-43d1-8197-d2272951b8e0"],
Cell[134608, 2694, 2692, 52, 668, "Output",ExpressionUUID->"7c34180f-171c-4bb7-ac61-658e8a12fdf4"],
Cell[CellGroupData[{
Cell[137325, 2750, 522, 10, 46, "Print",ExpressionUUID->"e5ff4ab8-7a6a-435a-bbc9-e6602ebf9acd"],
Cell[137850, 2762, 311, 5, 46, "Print",ExpressionUUID->"4ca4c1f1-63c6-48bd-8235-6c23ea5a829d"],
Cell[138164, 2769, 503, 10, 46, "Print",ExpressionUUID->"1d95b435-51b5-47c8-83af-312751ddea56"],
Cell[138670, 2781, 532, 10, 46, "Print",ExpressionUUID->"1dd51557-0f1f-4d33-a2f3-3ef7e7f2b1d3"],
Cell[139205, 2793, 510, 11, 46, "Print",ExpressionUUID->"317282ba-e256-4024-a539-fbbddaabfad4"],
Cell[139718, 2806, 321, 5, 46, "Print",ExpressionUUID->"b8226142-57ee-41ae-b7fd-58d6d107f081"],
Cell[140042, 2813, 320, 5, 46, "Print",ExpressionUUID->"8a55cd08-f216-4049-8ccc-308594a42915"],
Cell[140365, 2820, 548, 12, 46, "Print",ExpressionUUID->"cb9d4ab8-c1bb-4852-b77c-788344459eef"],
Cell[140916, 2834, 431, 9, 46, "Print",ExpressionUUID->"0bd3b650-d18c-4663-92bc-d28fa6755918"],
Cell[141350, 2845, 318, 5, 46, "Print",ExpressionUUID->"47fe4d89-0bd7-4426-be21-eea92a7c50b3"],
Cell[141671, 2852, 554, 13, 46, "Print",ExpressionUUID->"0ca80475-ce21-4365-8113-aa9c5c5123fb"]
}, Open  ]],
Cell[142240, 2868, 951, 14, 66, "Output",ExpressionUUID->"9712e70b-223f-4bda-b200-f4188962a5ba"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[143240, 2888, 223, 4, 106, "Subsection",ExpressionUUID->"a80fe639-eef2-45f4-96f5-fa98d53d1a10"],
Cell[CellGroupData[{
Cell[143488, 2896, 1564, 29, 252, "Input",ExpressionUUID->"c4aa9953-6015-4210-afb3-cc2ee6f5eb12"],
Cell[145055, 2927, 4035, 84, 480, "Output",ExpressionUUID->"138bfc1b-ef62-439b-b683-416ef1dcd8ff"],
Cell[CellGroupData[{
Cell[149115, 3015, 522, 10, 46, "Print",ExpressionUUID->"e65365d1-5f84-49ba-8e61-284d9fd14a70"],
Cell[149640, 3027, 315, 5, 46, "Print",ExpressionUUID->"4a34e3a2-d2c6-4ecc-a886-ed3cb49a71d8"],
Cell[149958, 3034, 505, 10, 46, "Print",ExpressionUUID->"730ee066-02bf-4e10-a24e-387f94754e3f"],
Cell[150466, 3046, 532, 10, 46, "Print",ExpressionUUID->"5bdc4d32-751c-42df-8b53-07de2e34e32d"],
Cell[151001, 3058, 512, 11, 46, "Print",ExpressionUUID->"54d83e20-4aa7-403a-8436-655eac01ec17"],
Cell[151516, 3071, 321, 5, 46, "Print",ExpressionUUID->"384c8397-62b3-49fe-a191-458532df7587"],
Cell[151840, 3078, 324, 5, 46, "Print",ExpressionUUID->"abcdc23b-cffa-4104-9c2c-8d6fcb37ff8d"],
Cell[152167, 3085, 552, 12, 46, "Print",ExpressionUUID->"03e92615-72b7-4037-a7d3-7190b8424d37"],
Cell[152722, 3099, 433, 9, 46, "Print",ExpressionUUID->"3d5d1e9e-cae9-4402-8080-4d4a4c8182b9"],
Cell[153158, 3110, 320, 5, 46, "Print",ExpressionUUID->"63b7a738-9a8a-4adf-845b-5a1d3554ba84"],
Cell[153481, 3117, 556, 13, 46, "Print",ExpressionUUID->"6a8e931c-64e3-4a44-a8ce-f36398d27ceb"]
}, Open  ]],
Cell[154052, 3133, 612, 8, 66, "Output",ExpressionUUID->"e4cff76d-fc89-495d-bf2b-2abec351e652"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154713, 3147, 443, 6, 106, "Subsection",ExpressionUUID->"525ae2f7-fe79-4cd5-a91e-cb7342e83d33"],
Cell[CellGroupData[{
Cell[155181, 3157, 1614, 32, 282, "Input",ExpressionUUID->"e825f494-0466-4101-9211-195fd581196b"],
Cell[156798, 3191, 2529, 51, 404, "Output",ExpressionUUID->"73a6afc6-7e00-4943-b44f-7c709c5a3bad"],
Cell[CellGroupData[{
Cell[159352, 3246, 745, 14, 46, "Print",ExpressionUUID->"e842ea69-92b6-4bff-b717-b998fadd499e"],
Cell[160100, 3262, 536, 9, 46, "Print",ExpressionUUID->"db428f00-f55f-4167-81dc-8aab16235533"],
Cell[160639, 3273, 728, 14, 46, "Print",ExpressionUUID->"2c9d6182-10ce-4d1a-b8d5-cc001bc0b0bc"],
Cell[161370, 3289, 755, 14, 46, "Print",ExpressionUUID->"4436347c-a882-40d3-9d02-32b02fc10698"],
Cell[162128, 3305, 734, 15, 46, "Print",ExpressionUUID->"afb27ae0-f3c1-44fd-99bb-e16681d23006"],
Cell[162865, 3322, 546, 9, 46, "Print",ExpressionUUID->"2f48cced-6e7c-45cb-bafe-01cdaf5734e4"],
Cell[163414, 3333, 545, 9, 46, "Print",ExpressionUUID->"859ceac4-3aa9-4c67-afc6-e73e93f4ddd9"],
Cell[163962, 3344, 772, 16, 46, "Print",ExpressionUUID->"cb6088ed-57e4-4bc4-a538-f74712462cf9"],
Cell[164737, 3362, 656, 13, 46, "Print",ExpressionUUID->"dfa234a2-9cf1-4c69-aea7-a175a6ef10d2"],
Cell[165396, 3377, 543, 9, 46, "Print",ExpressionUUID->"c22564bb-1c1b-4c03-808a-70392c780b33"],
Cell[165942, 3388, 779, 17, 46, "Print",ExpressionUUID->"12066274-47fb-4f16-b226-587ffa6ec8d8"]
}, Open  ]],
Cell[166736, 3408, 531, 8, 66, "Output",ExpressionUUID->"d240213e-17ae-4390-88a0-65dba34c377f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[167316, 3422, 205, 3, 106, "Subsection",ExpressionUUID->"3a577e16-983e-4c54-a12d-c377f678a17d"],
Cell[CellGroupData[{
Cell[167546, 3429, 1392, 29, 282, "Input",ExpressionUUID->"fb3e59ad-1649-4a2b-945b-cafdf7c44403"],
Cell[168941, 3460, 2346, 48, 404, "Output",ExpressionUUID->"6ebd9206-f975-4423-a2ed-41f8ece472d8"],
Cell[CellGroupData[{
Cell[171312, 3512, 624, 12, 46, "Print",ExpressionUUID->"66c65e6a-8670-4ab4-b056-46810c2a7f20"],
Cell[171939, 3526, 415, 7, 46, "Print",ExpressionUUID->"0180b551-8d63-4c30-ad3e-61c009fd6a04"],
Cell[172357, 3535, 609, 12, 46, "Print",ExpressionUUID->"17b1d9b2-5f73-487c-bea6-eb5e582b3e7e"],
Cell[172969, 3549, 634, 12, 46, "Print",ExpressionUUID->"128d3dc8-cf0d-49e2-a43f-5ccab62743c1"],
Cell[173606, 3563, 616, 13, 46, "Print",ExpressionUUID->"b143d9ad-7e60-4531-80d8-c54d15967e86"],
Cell[174225, 3578, 423, 7, 46, "Print",ExpressionUUID->"8622eab0-d9f3-4a61-87cf-30d60ce6b664"],
Cell[174651, 3587, 426, 7, 46, "Print",ExpressionUUID->"ae508162-0c84-422a-83e9-f0d0c696d211"],
Cell[175080, 3596, 652, 14, 46, "Print",ExpressionUUID->"30a6364c-346e-4993-b67c-821bce094ceb"],
Cell[175735, 3612, 535, 11, 46, "Print",ExpressionUUID->"24c0472f-8cde-448b-ba4b-aeaa0e6be9e1"],
Cell[176273, 3625, 421, 7, 46, "Print",ExpressionUUID->"fd46a76b-d454-446d-b1da-14327add3399"],
Cell[176697, 3634, 658, 15, 46, "Print",ExpressionUUID->"a38f6b11-aaf7-4cae-b609-e58e0a957afe"]
}, Open  ]],
Cell[177370, 3652, 418, 6, 66, "Output",ExpressionUUID->"a5ce1003-d68d-461b-9b58-5430062b3970"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[177837, 3664, 275, 4, 106, "Subsection",ExpressionUUID->"addc83d4-5155-4af4-889b-c07e285411e1"],
Cell[CellGroupData[{
Cell[178137, 3672, 1789, 35, 322, "Input",ExpressionUUID->"97ffcfd2-2152-45cc-9fe1-cd16d8503d69"],
Cell[179929, 3709, 2095, 44, 674, "Output",ExpressionUUID->"a5c4670e-6ca5-4bea-93e8-e9feb2525978"],
Cell[CellGroupData[{
Cell[182049, 3757, 694, 13, 46, "Print",ExpressionUUID->"012771b9-fa1e-4df1-9c5d-eeaa804bc743"],
Cell[182746, 3772, 487, 8, 46, "Print",ExpressionUUID->"b634da0a-7f8e-41b3-b77a-8f04f8c2079a"],
Cell[183236, 3782, 677, 13, 46, "Print",ExpressionUUID->"a3cf1f71-2215-4b3a-a1b1-f2c9920f25d1"],
Cell[183916, 3797, 704, 13, 46, "Print",ExpressionUUID->"24a416bf-c471-458e-ba36-103ef3b9f899"],
Cell[184623, 3812, 684, 14, 46, "Print",ExpressionUUID->"54ccefc6-2b53-49e5-a722-c63b33430a2d"],
Cell[185310, 3828, 493, 8, 46, "Print",ExpressionUUID->"cf281fb0-bad5-49ca-bbbf-b6317484f531"],
Cell[185806, 3838, 494, 8, 46, "Print",ExpressionUUID->"cefa074f-2635-4d50-bf04-bc5899a69105"],
Cell[186303, 3848, 722, 15, 46, "Print",ExpressionUUID->"746c96b1-a933-4d36-893e-4de98426cd9b"],
Cell[187028, 3865, 607, 12, 46, "Print",ExpressionUUID->"06f1ccf2-943a-4972-a5a4-e82c7e8c726d"],
Cell[187638, 3879, 492, 8, 46, "Print",ExpressionUUID->"a2d5595a-c3ad-496b-9496-28d7f607a2b7"],
Cell[188133, 3889, 728, 16, 46, "Print",ExpressionUUID->"79fe6cd7-b96f-4e30-b3e5-c02a810accaa"]
}, Open  ]],
Cell[188876, 3908, 481, 7, 66, "Output",ExpressionUUID->"e9ebae8e-b6f2-4ba8-a5a4-e7385d89bbbe"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[189406, 3921, 183, 3, 106, "Subsection",ExpressionUUID->"5466315c-7069-4a5e-ab14-830fe42ccbbe"],
Cell[CellGroupData[{
Cell[189614, 3928, 2368, 59, 292, "Input",ExpressionUUID->"fea70c67-5cbd-49be-9d49-a33247307087"],
Cell[191985, 3989, 4028, 87, 684, "Output",ExpressionUUID->"f2158e23-1b6a-439e-9b97-cd513edb49f2"],
Cell[CellGroupData[{
Cell[196038, 4080, 597, 11, 46, "Print",ExpressionUUID->"ec1ff163-a8fd-4172-863a-30641ac13831"],
Cell[196638, 4093, 386, 6, 46, "Print",ExpressionUUID->"5bd824a8-6052-419e-8634-39503553c079"],
Cell[197027, 4101, 578, 11, 46, "Print",ExpressionUUID->"c207ba6d-8394-40a8-8047-1a2f3f09c042"],
Cell[197608, 4114, 607, 11, 46, "Print",ExpressionUUID->"56cfdac2-8e95-47fc-adea-2893a03678f5"],
Cell[198218, 4127, 585, 12, 46, "Print",ExpressionUUID->"024ccf24-231d-4f9f-9737-48856758ae5f"],
Cell[198806, 4141, 396, 6, 46, "Print",ExpressionUUID->"7be3f2e9-8ba5-4909-9186-ff3a0ff9cac6"],
Cell[199205, 4149, 395, 6, 46, "Print",ExpressionUUID->"2821b78b-1ca3-4df8-b72d-e8aaa158ad4c"],
Cell[199603, 4157, 623, 13, 46, "Print",ExpressionUUID->"437a05bd-2f22-4d07-94a7-e66f2b518784"],
Cell[200229, 4172, 505, 10, 46, "Print",ExpressionUUID->"90e799c9-7f9d-44b7-b52e-13ef36828493"],
Cell[200737, 4184, 393, 6, 46, "Print",ExpressionUUID->"654a8542-5b1d-46a4-8bbd-55230bd53c66"],
Cell[201133, 4192, 629, 14, 46, "Print",ExpressionUUID->"f2c34f25-60ad-471f-82f1-b660b1e7196b"]
}, Open  ]],
Cell[201777, 4209, 386, 5, 66, "Output",ExpressionUUID->"8fa4b208-a9a1-4d50-9c36-0440330e9956"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[202212, 4220, 195, 3, 106, "Subsection",ExpressionUUID->"da9ff9c7-2ac2-4f6d-87a4-dfe973662d52"],
Cell[CellGroupData[{
Cell[202432, 4227, 2198, 56, 363, "Input",ExpressionUUID->"7735a67e-232a-4ed9-a67f-9ae4e9463180"],
Cell[204633, 4285, 7784, 150, 768, "Output",ExpressionUUID->"bb7aa20c-693b-4bad-8988-67b4765c2e9a"],
Cell[CellGroupData[{
Cell[212442, 4439, 494, 10, 46, "Print",ExpressionUUID->"0a7dec8d-ebd8-4b9f-b1cb-45d57cc3c199"],
Cell[212939, 4451, 285, 5, 46, "Print",ExpressionUUID->"e598dd65-2e85-4bd4-b3e3-49ea8c5f6cd6"],
Cell[213227, 4458, 479, 10, 46, "Print",ExpressionUUID->"fbe5425f-d5b0-4a9b-af46-f4abd14f1f61"],
Cell[213709, 4470, 504, 10, 46, "Print",ExpressionUUID->"9d57c086-ac7a-4bd6-bf11-426f715a6996"],
Cell[214216, 4482, 484, 11, 46, "Print",ExpressionUUID->"3901128a-e4ae-4d08-b1f0-64f6321bfed7"],
Cell[214703, 4495, 293, 5, 46, "Print",ExpressionUUID->"c195de48-c48e-4d3b-9a92-edce1e0a6c8e"],
Cell[214999, 4502, 294, 5, 46, "Print",ExpressionUUID->"3ecaf290-d8cd-43d7-ac10-3470352c9cd0"],
Cell[215296, 4509, 522, 12, 46, "Print",ExpressionUUID->"b51b9ddf-83da-43e4-a679-4ee928006d6f"],
Cell[215821, 4523, 405, 9, 46, "Print",ExpressionUUID->"bec962e4-c8f8-46b0-bfbc-6d255b5132cd"],
Cell[216229, 4534, 294, 5, 46, "Print",ExpressionUUID->"2c440218-c296-4ca0-b702-6f38bf099113"],
Cell[216526, 4541, 528, 13, 46, "Print",ExpressionUUID->"7f13a566-6622-48d8-ae75-22d24f9c7da2"]
}, Open  ]],
Cell[217069, 4557, 289, 4, 66, "Output",ExpressionUUID->"5bdf71e5-668e-4fc0-b802-929cb546ff5a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[217407, 4567, 196, 3, 106, "Subsection",ExpressionUUID->"8ee55263-5dd4-49cf-ae54-4f475395cc43"],
Cell[CellGroupData[{
Cell[217628, 4574, 1989, 52, 252, "Input",ExpressionUUID->"ca3cf79c-b7ca-4bad-9ce1-560cea9496a4"],
Cell[219620, 4628, 5853, 110, 758, "Output",ExpressionUUID->"c5ce72d9-7daa-4385-b909-72242c11d0af"],
Cell[CellGroupData[{
Cell[225498, 4742, 567, 12, 46, "Print",ExpressionUUID->"4b51449b-8726-409e-bac5-dccf4d0140b4"],
Cell[226068, 4756, 359, 7, 46, "Print",ExpressionUUID->"9cb278d6-ca0f-4f20-a753-946e3c652136"],
Cell[226430, 4765, 553, 12, 46, "Print",ExpressionUUID->"c6b18a62-5bd6-44b6-a0f5-100d29499fcf"],
Cell[226986, 4779, 580, 12, 46, "Print",ExpressionUUID->"59734f79-cb08-4307-b73c-d389327e90a7"],
Cell[227569, 4793, 558, 13, 46, "Print",ExpressionUUID->"8cf84d26-68b6-42fe-81f3-37aeef52fb21"],
Cell[228130, 4808, 367, 7, 46, "Print",ExpressionUUID->"ab0fef4c-2643-4430-81f1-44c0401bbf6c"],
Cell[228500, 4817, 368, 7, 46, "Print",ExpressionUUID->"26c668ea-75b4-4301-821b-4ff283d63412"],
Cell[228871, 4826, 596, 14, 46, "Print",ExpressionUUID->"bd71d9b1-e847-41a6-b8db-2635cfaf1c36"],
Cell[229470, 4842, 481, 11, 46, "Print",ExpressionUUID->"aa73ac03-9e36-497c-b345-8eabdb0ea8c1"],
Cell[229954, 4855, 366, 7, 46, "Print",ExpressionUUID->"88f1dfb0-dfb6-437f-a076-bfb184b9c7b6"],
Cell[230323, 4864, 604, 15, 46, "Print",ExpressionUUID->"5f23e130-9c43-46ed-a745-878bb45077cf"]
}, Open  ]],
Cell[230942, 4882, 364, 6, 98, "Output",ExpressionUUID->"f15d31dd-c348-4cb9-a546-a8c6ca2ba80b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[231355, 4894, 182, 3, 106, "Subsection",ExpressionUUID->"6e84a932-cc10-41ba-89b6-cfdc96bb86aa"],
Cell[CellGroupData[{
Cell[231562, 4901, 2697, 55, 748, "Input",ExpressionUUID->"3b8a0015-13ed-4218-9947-0c0b685cc52f"],
Cell[234262, 4958, 2441, 49, 761, "Output",ExpressionUUID->"340ac076-ba55-4aae-81d6-853c65d91893"],
Cell[CellGroupData[{
Cell[236728, 5011, 517, 10, 46, "Print",ExpressionUUID->"b3f5eafa-5a72-4350-a691-2a52e0de9e32"],
Cell[237248, 5023, 308, 5, 46, "Print",ExpressionUUID->"9b27015b-5d49-49c1-905d-4cb32d401634"],
Cell[237559, 5030, 502, 10, 46, "Print",ExpressionUUID->"f1e457d7-e617-41ae-b69a-08997b90be27"],
Cell[238064, 5042, 529, 10, 46, "Print",ExpressionUUID->"962c25f5-1ec8-4f98-bef5-cc681f408b29"],
Cell[238596, 5054, 507, 11, 46, "Print",ExpressionUUID->"e592d44b-6201-444e-9382-ba5eb037f2f1"],
Cell[239106, 5067, 316, 5, 46, "Print",ExpressionUUID->"39f2c9da-1039-4946-b441-a76a8c4c500b"],
Cell[239425, 5074, 315, 5, 46, "Print",ExpressionUUID->"856679fc-7441-4464-9fe4-645ec00b9be0"],
Cell[239743, 5081, 547, 12, 46, "Print",ExpressionUUID->"a0c228d6-3f63-4b5b-934b-a09e67d476bf"],
Cell[240293, 5095, 428, 9, 46, "Print",ExpressionUUID->"967f4d58-7a8c-40ef-be4a-9506e5bd0448"],
Cell[240724, 5106, 315, 5, 46, "Print",ExpressionUUID->"37d7dc27-15e4-4eb1-9f29-bbe53ad4bfe7"],
Cell[241042, 5113, 551, 13, 46, "Print",ExpressionUUID->"5e3600e1-abb5-48ef-b889-3b1771afc0c5"]
}, Open  ]],
Cell[241608, 5129, 312, 4, 98, "Output",ExpressionUUID->"f3c1a61d-5235-4689-8159-25cf3006967b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[241969, 5139, 229, 4, 106, "Subsection",ExpressionUUID->"67d8266d-ccbb-4e6e-99a0-3bd14c3ad595"],
Cell[CellGroupData[{
Cell[242223, 5147, 1371, 25, 211, "Input",ExpressionUUID->"8a4c3f5d-db8e-4f62-8d84-6cdd1c58b70b"],
Cell[243597, 5174, 7840, 162, 398, "Output",ExpressionUUID->"4b98f525-483e-47c7-b096-77fe6eb9ebe6"],
Cell[CellGroupData[{
Cell[251462, 5340, 499, 10, 46, "Print",ExpressionUUID->"a2cb9a63-f859-4d5d-92ee-d43635bfa5f8"],
Cell[251964, 5352, 288, 5, 46, "Print",ExpressionUUID->"bafd3314-4f94-423e-82d1-43fdde774b90"],
Cell[252255, 5359, 480, 10, 46, "Print",ExpressionUUID->"71def0af-7f9b-41e6-8739-8925381f4419"],
Cell[252738, 5371, 506, 10, 46, "Print",ExpressionUUID->"03ab8ff4-3eae-47a5-8a8e-1ec144204e97"],
Cell[253247, 5383, 487, 11, 46, "Print",ExpressionUUID->"66b1201f-9f53-48b8-b143-60c658acc9a7"],
Cell[253737, 5396, 296, 5, 46, "Print",ExpressionUUID->"dd954f92-201f-46b5-a913-9737ffcab9a2"],
Cell[254036, 5403, 299, 5, 46, "Print",ExpressionUUID->"961b6589-4680-41e7-8335-edb71397a6ed"],
Cell[254338, 5410, 531, 13, 46, "Print",ExpressionUUID->"0bc40c60-debd-42f5-9930-4fbf1b101279"],
Cell[254872, 5425, 410, 9, 46, "Print",ExpressionUUID->"60314599-6b0b-45fd-9ae8-2a139c205da7"],
Cell[255285, 5436, 295, 5, 46, "Print",ExpressionUUID->"affcb6b6-2229-46fe-8473-336867b0ebf7"],
Cell[255583, 5443, 535, 13, 46, "Print",ExpressionUUID->"f19fd490-651e-4e70-afd3-ec72d3b281bc"]
}, Open  ]],
Cell[256133, 5459, 669, 10, 66, "Output",ExpressionUUID->"fc2346c3-1364-495d-b0e5-31f6fcf8618a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[256851, 5475, 188, 3, 106, "Subsection",ExpressionUUID->"07e1fe11-9e61-4468-bb69-30abaa8cde4d"],
Cell[CellGroupData[{
Cell[257064, 5482, 2334, 61, 404, "Input",ExpressionUUID->"97adc1f5-2e37-4b8e-ae12-1064943c513a"],
Cell[259401, 5545, 5317, 114, 600, "Output",ExpressionUUID->"682ae0f9-5dcf-45ed-b7ee-c5b5a64b3db8"],
Cell[CellGroupData[{
Cell[264743, 5663, 619, 12, 46, "Print",ExpressionUUID->"1626eded-c130-49c2-af4a-7c6c35ff6e9c"],
Cell[265365, 5677, 408, 7, 46, "Print",ExpressionUUID->"0c0f28b0-3913-417e-bfc8-384444897667"],
Cell[265776, 5686, 600, 12, 46, "Print",ExpressionUUID->"66ba596a-6935-4fb5-ac98-66230e31c451"],
Cell[266379, 5700, 627, 12, 46, "Print",ExpressionUUID->"d6069222-8aa1-4a41-a05c-c1be3c49cc26"],
Cell[267009, 5714, 609, 13, 46, "Print",ExpressionUUID->"0105ff20-ea67-4cda-bf9b-886584553ed6"],
Cell[267621, 5729, 418, 7, 46, "Print",ExpressionUUID->"02306f5e-9f47-4947-b635-4d2b0d56eda3"],
Cell[268042, 5738, 417, 7, 46, "Print",ExpressionUUID->"88c45a73-fdf4-4d22-9477-5604710c45f3"],
Cell[268462, 5747, 650, 15, 46, "Print",ExpressionUUID->"b4d7737f-40b1-493b-bf39-1b6b601f1841"],
Cell[269115, 5764, 532, 11, 46, "Print",ExpressionUUID->"d2666bd2-cad7-4578-ae38-6185a55d794d"],
Cell[269650, 5777, 415, 7, 46, "Print",ExpressionUUID->"7d2e005f-435a-475d-beab-e6f632ae78f9"],
Cell[270068, 5786, 655, 15, 46, "Print",ExpressionUUID->"02a06123-3d5f-443e-b5b8-0f54caa6feee"]
}, Open  ]],
Cell[270738, 5804, 413, 6, 66, "Output",ExpressionUUID->"076b709a-fbe7-48b3-a372-ddc40ee72dc6"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[271200, 5816, 174, 3, 106, "Subsection",ExpressionUUID->"3fa4bec0-b663-40db-8099-11fbdeaab78a"],
Cell[CellGroupData[{
Cell[271399, 5823, 1317, 23, 211, "Input",ExpressionUUID->"38bb44b8-f46e-45ca-af88-ea9f5c46a2bb"],
Cell[272719, 5848, 4479, 95, 736, "Output",ExpressionUUID->"0bf9d912-db49-4a56-bc37-09ab8417ce63"],
Cell[CellGroupData[{
Cell[277223, 5947, 496, 10, 46, "Print",ExpressionUUID->"98945ebd-4d16-4462-806d-eb076417a429"],
Cell[277722, 5959, 287, 5, 46, "Print",ExpressionUUID->"d1541bc3-fb6c-400f-9e65-c1656250eb48"],
Cell[278012, 5966, 479, 10, 46, "Print",ExpressionUUID->"7fbd6d28-0f25-4aa9-bccb-ea0b002e52b9"],
Cell[278494, 5978, 506, 10, 46, "Print",ExpressionUUID->"41cc2389-2572-4651-ad8d-95750d8a31d9"],
Cell[279003, 5990, 488, 11, 46, "Print",ExpressionUUID->"c89e00db-ef2a-42c1-b893-cdb81bdd268b"],
Cell[279494, 6003, 295, 5, 46, "Print",ExpressionUUID->"5a77f68a-859e-4e6a-b8e5-15fda24036ee"],
Cell[279792, 6010, 296, 5, 46, "Print",ExpressionUUID->"0eb9be1e-7ab0-40c1-a539-2162e74e80db"],
Cell[280091, 6017, 532, 13, 46, "Print",ExpressionUUID->"eb966f79-f1dc-40be-86f6-12ab70912f56"],
Cell[280626, 6032, 409, 9, 46, "Print",ExpressionUUID->"915d26fc-2c93-403a-a183-d3683c0da1a4"],
Cell[281038, 6043, 296, 5, 46, "Print",ExpressionUUID->"f19b90d1-5ec0-44ae-82b4-72e301d56844"],
Cell[281337, 6050, 536, 13, 46, "Print",ExpressionUUID->"13c41cf1-bcf4-4fa4-97bd-2991904632cc"]
}, Open  ]],
Cell[281888, 6066, 367, 6, 66, "Output",ExpressionUUID->"18ca12c8-e374-4246-99be-bd55cc2650ac"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[282304, 6078, 199, 3, 106, "Subsection",ExpressionUUID->"498cddc4-9a73-4f0c-9894-236d8250ca13"],
Cell[CellGroupData[{
Cell[282528, 6085, 1415, 25, 252, "Input",ExpressionUUID->"0e79a95f-e8d6-47d7-931c-936bc2e79c2f"],
Cell[283946, 6112, 5261, 110, 721, "Output",ExpressionUUID->"e73ebee0-41fe-4271-9a3e-0164a6169c27"],
Cell[CellGroupData[{
Cell[289232, 6226, 570, 11, 46, "Print",ExpressionUUID->"ec8ceb0a-3b23-4569-b31f-713626f46570"],
Cell[289805, 6239, 360, 6, 46, "Print",ExpressionUUID->"38b71e0c-58ce-4ad1-aa31-a892c23e1f1d"],
Cell[290168, 6247, 555, 11, 46, "Print",ExpressionUUID->"7f65b20c-1ce9-4187-bd80-bc75822f22b1"],
Cell[290726, 6260, 580, 11, 46, "Print",ExpressionUUID->"5ad9f659-15e8-48e2-8b1e-dfeefb419f04"],
Cell[291309, 6273, 560, 12, 46, "Print",ExpressionUUID->"b4fe3640-db86-4ed7-a2ca-033410acf119"],
Cell[291872, 6287, 369, 6, 46, "Print",ExpressionUUID->"30a6093b-a351-4e40-906c-281fab710a64"],
Cell[292244, 6295, 372, 6, 46, "Print",ExpressionUUID->"74aaf00c-873e-4502-a421-aadc44fb145b"],
Cell[292619, 6303, 604, 14, 46, "Print",ExpressionUUID->"46d27836-898d-4423-8dfe-25dccaa34e7d"],
Cell[293226, 6319, 483, 10, 46, "Print",ExpressionUUID->"6e2efb6c-8dcd-4d88-8116-17fbf9f1ce16"],
Cell[293712, 6331, 368, 6, 46, "Print",ExpressionUUID->"6499dab1-ab56-4199-b72c-cec54f344412"],
Cell[294083, 6339, 610, 14, 46, "Print",ExpressionUUID->"8bb95386-64cb-40d0-b12b-4ff37b75dbf0"]
}, Open  ]],
Cell[294708, 6356, 360, 5, 66, "Output",ExpressionUUID->"c37a2835-eb89-414a-80d4-13696aab9bee"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[295117, 6367, 225, 4, 106, "Subsection",ExpressionUUID->"1abdddcd-68b6-4073-8362-12f79fc556d7"],
Cell[CellGroupData[{
Cell[295367, 6375, 1693, 28, 252, "Input",ExpressionUUID->"a927117d-7898-4cf0-96a7-e41dea057a06"],
Cell[297063, 6405, 4073, 87, 667, "Output",ExpressionUUID->"121dc3b8-ecd8-4f9f-98b5-396ebc9279de"],
Cell[CellGroupData[{
Cell[301161, 6496, 612, 12, 46, "Print",ExpressionUUID->"996198bc-3bf6-4215-a60a-9792934917e9"],
Cell[301776, 6510, 401, 7, 46, "Print",ExpressionUUID->"68b244e4-59be-48fd-929f-6e492b5f1fad"],
Cell[302180, 6519, 593, 12, 46, "Print",ExpressionUUID->"beaf6566-17e7-4120-9d17-43831b30466b"],
Cell[302776, 6533, 620, 12, 46, "Print",ExpressionUUID->"3c07ace4-f133-4d78-b9b6-5a178b92c5ae"],
Cell[303399, 6547, 600, 13, 46, "Print",ExpressionUUID->"88c13427-c54b-4195-ad55-6b29e3e42e92"],
Cell[304002, 6562, 409, 7, 46, "Print",ExpressionUUID->"8adedcb8-850f-4193-aede-a5ee9c7270de"],
Cell[304414, 6571, 410, 7, 46, "Print",ExpressionUUID->"06a41907-822e-4f38-8819-a7927fc11c9d"],
Cell[304827, 6580, 644, 15, 46, "Print",ExpressionUUID->"a07b8d45-3962-4458-8f79-84778a37d8d6"],
Cell[305474, 6597, 523, 11, 46, "Print",ExpressionUUID->"cc8110a7-706e-4967-8321-39212d3bea52"],
Cell[306000, 6610, 408, 7, 46, "Print",ExpressionUUID->"87791ce7-c8ea-45e8-8407-a43895695ed7"],
Cell[306411, 6619, 647, 15, 46, "Print",ExpressionUUID->"b42e417b-8cd0-4a09-a5f1-6e5dae0f9149"]
}, Open  ]],
Cell[307073, 6637, 413, 6, 66, "Output",ExpressionUUID->"b8ac4585-9c4f-4758-862f-07814ff80e36"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[307535, 6649, 225, 4, 106, "Subsection",ExpressionUUID->"8945b796-8e9d-43a7-b545-a2ed38d373ca"],
Cell[CellGroupData[{
Cell[307785, 6657, 1568, 28, 252, "Input",ExpressionUUID->"5d007e7d-9158-4ba9-923b-727688cdb386"],
Cell[309356, 6687, 4919, 106, 721, "Output",ExpressionUUID->"30950fac-6171-4032-b9ca-6db2e68f1c58"],
Cell[CellGroupData[{
Cell[314300, 6797, 500, 11, 46, "Print",ExpressionUUID->"e001c0f9-1e7f-474f-910e-3b30b933fd88"],
Cell[314803, 6810, 291, 6, 46, "Print",ExpressionUUID->"72e80f68-286d-44bc-a089-1f265fcd0e5b"],
Cell[315097, 6818, 483, 11, 46, "Print",ExpressionUUID->"cac4fc04-e963-4106-b21a-c92676ac8561"],
Cell[315583, 6831, 510, 11, 46, "Print",ExpressionUUID->"fa0cb892-0329-437a-a95d-773c98b85b9f"],
Cell[316096, 6844, 492, 12, 46, "Print",ExpressionUUID->"213d9fd5-c409-49b6-b716-e7dee76ab69c"],
Cell[316591, 6858, 299, 6, 46, "Print",ExpressionUUID->"2a84e5c6-8276-429d-8271-ed045ab8f7e5"],
Cell[316893, 6866, 302, 6, 46, "Print",ExpressionUUID->"fc94c911-0995-4e8a-a059-23773c53a7c1"],
Cell[317198, 6874, 534, 14, 46, "Print",ExpressionUUID->"70ab9379-49c6-455e-b65f-ae7c1a8913aa"],
Cell[317735, 6890, 415, 10, 46, "Print",ExpressionUUID->"d3b9b026-72c1-4abe-bc9b-2dca75578405"],
Cell[318153, 6902, 300, 6, 46, "Print",ExpressionUUID->"d207b623-1595-465c-a30a-3c5e7ea3cb35"],
Cell[318456, 6910, 540, 14, 46, "Print",ExpressionUUID->"fcc9459f-9f60-482f-89a8-56e217137734"]
}, Open  ]],
Cell[319011, 6927, 295, 6, 98, "Output",ExpressionUUID->"0d91c99b-0249-4e4c-9bc3-84ebf1f9b6f0"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

